/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.core.runtime.CoreException;

public class CPPArrayType
implements IArrayType,
ITypeContainer,
ISerializableType {
    private IType type;
    private IASTExpression sizeExpression;
    private IValue value = Value.NOT_INITIALIZED;

    public CPPArrayType(IType type, IValue value) {
        this.value = value;
        this.setType(type);
    }

    public CPPArrayType(IType type, IASTExpression sizeExp) {
        this.sizeExpression = sizeExp;
        this.setType(type);
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        assert (t != null);
        this.type = t;
    }

    public boolean isSameType(IType obj) {
        IArrayType rhs;
        IType objType;
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return ((ITypedef)obj).isSameType(this);
        }
        if (obj instanceof IArrayType && (objType = (rhs = (IArrayType)obj).getType()) != null && objType.isSameType(this.type)) {
            IValue s2;
            IValue s1 = this.getSize();
            if (s1 == (s2 = rhs.getSize())) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            return CharArrayUtils.equals(s1.getSignature(), s2.getSignature());
        }
        return false;
    }

    public IValue getSize() {
        if (this.value != Value.NOT_INITIALIZED) {
            return this.value;
        }
        if (this.sizeExpression == null) {
            this.value = null;
            return null;
        }
        this.value = Value.create(this.sizeExpression, 25);
        return this.value;
    }

    @Deprecated
    public IASTExpression getArraySizeExpression() {
        return this.sizeExpression;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        long lnum;
        IValue val = this.getSize();
        if (val == null) {
            buffer.putByte((byte)3);
            buffer.marshalType(this.getType());
            return;
        }
        Long num = val.numericalValue();
        if (num != null && (lnum = num.longValue()) >= 0L && lnum <= 32767L) {
            buffer.putByte((byte)19);
            buffer.putShort((short)lnum);
            buffer.marshalType(this.getType());
            return;
        }
        buffer.putByte((byte)35);
        buffer.marshalValue(val);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IValue value = null;
        if ((firstByte & 0x10) != 0) {
            value = Value.create(buffer.getShort());
        } else if ((firstByte & 0x20) != 0) {
            value = buffer.unmarshalValue();
        }
        IType nested = buffer.unmarshalType();
        return new CPPArrayType(nested, value);
    }
}

