/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPFunctionInstance
extends CPPFunctionSpecialization
implements ICPPTemplateInstance {
    private ICPPTemplateArgument[] fArguments;

    public CPPFunctionInstance(ICPPFunction orig, IBinding owner, CPPTemplateParameterMap argMap, ICPPTemplateArgument[] args) {
        super(orig, owner, (ICPPTemplateParameterMap)argMap);
        this.fArguments = args;
    }

    public ICPPTemplateDefinition getTemplateDefinition() {
        return (ICPPTemplateDefinition)this.getSpecializedBinding();
    }

    @Deprecated
    public IType[] getArguments() {
        return CPPTemplates.getArguments(this.fArguments);
    }

    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.fArguments;
    }

    public boolean isExplicitSpecialization() {
        if (this.getDefinition() != null) {
            return true;
        }
        IASTNode[] decls = this.getDeclarations();
        if (decls != null) {
            IASTNode[] iASTNodeArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode decl = iASTNodeArray[n2];
                if (decl != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " " + ASTTypeUtil.getArgumentListString(this.fArguments, true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICPPTemplateInstance && obj instanceof ICPPFunction) {
            ICPPFunctionType ct2;
            ICPPTemplateInstance inst = (ICPPTemplateInstance)obj;
            ICPPFunctionType ct1 = ((ICPPFunction)this.getSpecializedBinding()).getType();
            if (!ct1.isSameType(ct2 = ((ICPPFunction)((Object)inst.getTemplateDefinition())).getType())) {
                return false;
            }
            return CPPTemplates.haveSameArguments(this, inst);
        }
        return false;
    }
}

