/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.BitSet;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.AbstractGNUSourceCodeParser;

final class TemplateIdStrategy
implements AbstractGNUSourceCodeParser.ITemplateIdStrategy {
    private int fCurrentBranchPoint;
    private BitSet fSimpleIDs;
    private IASTName[] fTemplateNames;

    public TemplateIdStrategy() {
        this.reset();
    }

    public void reset() {
        this.fCurrentBranchPoint = -1;
        this.fTemplateNames = IASTName.EMPTY_NAME_ARRAY;
        if (this.fSimpleIDs != null) {
            this.fSimpleIDs.clear();
        }
    }

    public boolean ignoreTemplateID() {
        ++this.fCurrentBranchPoint;
        return this.fSimpleIDs == null ? false : this.fSimpleIDs.get(this.fCurrentBranchPoint);
    }

    public void addTemplateName(IASTName name) {
        this.fTemplateNames = ArrayUtil.append(this.fTemplateNames, name);
    }

    public boolean setNextAlternative() {
        int len;
        int bp = this.fCurrentBranchPoint;
        if (bp < 0) {
            return false;
        }
        this.fCurrentBranchPoint = -1;
        this.fTemplateNames = IASTName.EMPTY_NAME_ARRAY;
        if (this.fSimpleIDs == null) {
            this.fSimpleIDs = new BitSet();
        }
        if ((len = this.fSimpleIDs.length()) <= bp) {
            this.fSimpleIDs.set(bp);
            return true;
        }
        int branch = Math.min(bp, len - 2);
        while (branch >= 0) {
            if (!this.fSimpleIDs.get(branch)) {
                this.fSimpleIDs.clear(branch + 1, len);
                this.fSimpleIDs.set(branch);
                return true;
            }
            --branch;
        }
        return false;
    }

    public IASTName[] getTemplateNames() {
        return ArrayUtil.trim(this.fTemplateNames);
    }
}

