/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementDeltaBuilder;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CommitWorkingCopyOperation
extends CModelOperation {
    public CommitWorkingCopyOperation(ITranslationUnit element, boolean force) {
        super(new ICElement[]{element}, force);
    }

    public ISchedulingRule getSchedulingRule() {
        IResource resource = this.getElementToProcess().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    protected void executeOperation() throws CModelException {
        try {
            char[] originalContents;
            this.beginTask(CoreModelMessages.getString("workingCopy.commit"), 2);
            WorkingCopy wc = (WorkingCopy)this.getElementToProcess();
            ITranslationUnit tu = wc.getOriginalElement();
            if (!tu.isOpen()) {
                tu.open(null);
            }
            CElementDeltaBuilder deltaBuilder = new CElementDeltaBuilder(tu);
            boolean hasSaved = false;
            IBuffer tuBuffer = tu.getBuffer();
            IBuffer wcBuffer = wc.getBuffer();
            if (wcBuffer == null || tuBuffer == null) {
                return;
            }
            ITextFileBuffer tuFileBuffer = null;
            Object wcFileBuffer = null;
            if (tuBuffer instanceof IAdaptable) {
                tuFileBuffer = (ITextFileBuffer)((IAdaptable)tuBuffer).getAdapter(ITextFileBuffer.class);
            }
            if (wcBuffer instanceof IAdaptable) {
                wcFileBuffer = (ITextFileBuffer)((IAdaptable)wcBuffer).getAdapter(ITextFileBuffer.class);
            }
            if (wcFileBuffer != null) {
                if (wcFileBuffer.equals(tuFileBuffer)) {
                    tu.save(this.fMonitor, this.fForce);
                    hasSaved = true;
                } else if (wcFileBuffer.getLocation().equals((Object)tu.getPath())) {
                    originalContents = tuBuffer.getCharacters();
                    try {
                        wcFileBuffer.commit(this.fMonitor, this.fForce);
                        tuBuffer.setContents(wcBuffer.getCharacters());
                        tu.makeConsistent(null);
                        hasSaved = true;
                    }
                    catch (CoreException e) {
                        tuBuffer.setContents(originalContents);
                        throw new CModelException(e);
                    }
                }
            }
            if (!hasSaved) {
                originalContents = tuBuffer.getCharacters();
                try {
                    tuBuffer.setContents(wcBuffer.getCharacters());
                    tu.save(this.fMonitor, this.fForce);
                }
                catch (CModelException e) {
                    tuBuffer.setContents(originalContents);
                    throw e;
                }
            }
            this.hasModifiedResource = true;
            wc.updateTimeStamp((TranslationUnit)tu);
            wc.makeConsistent(this);
            this.worked(1);
            deltaBuilder.buildDeltas();
            if (deltaBuilder.delta != null) {
                this.addDelta(deltaBuilder.delta);
            }
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    public ICModelStatus verify() {
        IWorkingCopy wc = (IWorkingCopy)this.getElementToProcess();
        if (!wc.isWorkingCopy()) {
            return new CModelStatus(967, wc);
        }
        ITranslationUnit original = wc.getOriginalElement();
        IResource resource = original.getResource();
        if (!wc.isBasedOn(resource) && !this.fForce) {
            return new CModelStatus(981);
        }
        return CModelStatus.VERIFIED_OK;
    }
}

