/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IRegion;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.cdt.internal.core.model.Region;

public class DeleteElementsOperation
extends MultiOperation {
    protected Map<ITranslationUnit, IRegion> fChildrenToRemove;

    public DeleteElementsOperation(ICElement[] elementsToDelete, boolean force) {
        super(elementsToDelete, force);
    }

    protected String getMainTaskName() {
        return CoreModelMessages.getString("operation.deleteElementProgress");
    }

    protected void groupElements() throws CModelException {
        this.fChildrenToRemove = new HashMap<ITranslationUnit, IRegion>(1);
        int uniqueTUs = 0;
        ICElement[] iCElementArray = this.fElementsToProcess;
        int n = this.fElementsToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement e = iCElementArray[n2];
            ITranslationUnit tu = this.getTranslationUnitFor(e);
            if (tu == null) {
                throw new CModelException(new CModelStatus(976, e));
            }
            IRegion region = this.fChildrenToRemove.get(tu);
            if (region == null) {
                region = new Region();
                this.fChildrenToRemove.put(tu, region);
                ++uniqueTUs;
            }
            region.add(e);
            ++n2;
        }
        this.fElementsToProcess = new ICElement[uniqueTUs];
        Iterator<ITranslationUnit> iter = this.fChildrenToRemove.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.fElementsToProcess[i++] = iter.next();
        }
    }

    protected void processElement(ICElement element) throws CModelException {
        ICElement[] cuElements;
        ITranslationUnit tu = (ITranslationUnit)element;
        IBuffer buffer = tu.getBuffer();
        if (buffer == null) {
            return;
        }
        CElementDelta delta = new CElementDelta(tu);
        ICElement[] iCElementArray = cuElements = this.fChildrenToRemove.get(tu).getElements();
        int n = cuElements.length;
        int n2 = 0;
        while (n2 < n) {
            char[] contents;
            ICElement e = iCElementArray[n2];
            if (e.exists() && (contents = buffer.getCharacters()) != null) {
                String tuName = tu.getElementName();
                this.replaceElementInBuffer(buffer, e, tuName);
                delta.removed(e);
            }
            ++n2;
        }
        if (delta.getAffectedChildren().length > 0) {
            tu.save(this.getSubProgressMonitor(1), this.fForce);
            if (!tu.isWorkingCopy()) {
                this.addDelta(delta);
            }
        }
    }

    @Deprecated
    private void replaceElementInBuffer(IBuffer buffer, ICElement elementToRemove, String cuName) throws CModelException {
        if (elementToRemove instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)((Object)elementToRemove)).getSourceRange();
            int startPosition = range.getStartPos();
            int length = range.getLength();
            boolean newLineFound = false;
            int offset = range.getStartPos() + range.getLength();
            while (true) {
                try {
                    char c = buffer.getChar(offset);
                    if (c == ';') {
                        ++length;
                    } else if (c == '\r' || c == '\n') {
                        newLineFound = true;
                        ++length;
                    } else {
                        if (newLineFound || c != ' ') break;
                        ++length;
                    }
                }
                catch (Exception exception) {
                    break;
                }
                ++offset;
            }
            buffer.replace(startPosition, length, CharOperation.NO_CHAR);
        }
    }

    protected void processElements() throws CModelException {
        this.groupElements();
        super.processElements();
    }

    protected void verify(ICElement element) throws CModelException {
        ICElement[] children;
        ICElement[] iCElementArray = children = this.fChildrenToRemove.get(element).getElements();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child.getResource() != null) {
                this.error(967, child);
            }
            if (child.isReadOnly()) {
                this.error(976, child);
            }
            ++n2;
        }
    }
}

