/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.io.File;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class HostOS {
    public static boolean IS_WIN32 = File.separatorChar == '\\';
    public static boolean IS_UNIX = File.separatorChar == '/';
    public static final String EXE_EXT = IS_WIN32 ? ".exe" : "";

    public static String canonicalizeExecutableName(String executable) {
        Path executablePath;
        String ext;
        if (IS_WIN32 && (ext = (executablePath = new Path(executable)).getFileExtension()) == null) {
            executable = String.valueOf(executable) + EXE_EXT;
        }
        return executable;
    }

    public static IPath findProgramOnPath(String program, String pathValue) {
        IPath[] pathEntries;
        program = HostOS.canonicalizeExecutableName(program);
        IPath path = null;
        IPath[] iPathArray = pathEntries = PathUtils.getPathEntries(pathValue);
        int n = pathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath pathEntry = iPathArray[n2];
            IPath testPath = pathEntry.append(program);
            if (testPath.toFile().exists()) {
                path = testPath;
                break;
            }
            ++n2;
        }
        return path;
    }
}

