/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.archive.zip.ZipDriver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class ZipFileUtils {
    public static boolean deleteFileFromZip(String fileName, File zipFile, String[] extensions) {
        String archiveFileName = zipFile + de.schlichtherle.io.File.separator + fileName;
        ArchiveDetector detector = ZipFileUtils.getArchiveDetector(extensions);
        de.schlichtherle.io.File file = null;
        file = detector != null ? new de.schlichtherle.io.File(archiveFileName, detector) : new de.schlichtherle.io.File(archiveFileName);
        boolean success = file.delete();
        ZipFileUtils.unmount();
        return success;
    }

    public static boolean deleteFileFromZip(String fileName, File zipFile) {
        return ZipFileUtils.deleteFileFromZip(fileName, zipFile, null);
    }

    public static boolean addFileToZip(File src, File zipFile, String[] extensions) {
        boolean success = false;
        ArchiveDetector detector = ZipFileUtils.getArchiveDetector(extensions);
        de.schlichtherle.io.File toBeAddedFile = null;
        if (detector != null) {
            toBeAddedFile = new de.schlichtherle.io.File(src, detector);
            success = toBeAddedFile.archiveCopyTo((File)new de.schlichtherle.io.File(zipFile, toBeAddedFile.getName(), detector));
        } else {
            toBeAddedFile = new de.schlichtherle.io.File(src);
            success = toBeAddedFile.archiveCopyTo((File)new de.schlichtherle.io.File(zipFile, toBeAddedFile.getName()));
        }
        ZipFileUtils.unmount();
        return success;
    }

    public static boolean addFileToZip(File srcFile, File zipFile) {
        return ZipFileUtils.addFileToZip(srcFile, zipFile, null);
    }

    public static boolean addFilesToZip(File[] src, File zipFile, String[] extensions) {
        boolean success = false;
        ArchiveDetector detector = ZipFileUtils.getArchiveDetector(extensions);
        File[] fileArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            File currSrcFile = fileArray[n2];
            try {
                de.schlichtherle.io.File toBeAddedFile = null;
                if (detector != null) {
                    toBeAddedFile = new de.schlichtherle.io.File(currSrcFile.getCanonicalFile(), detector);
                    success = toBeAddedFile.archiveCopyTo((File)new de.schlichtherle.io.File(zipFile, toBeAddedFile.getName(), detector));
                } else {
                    toBeAddedFile = new de.schlichtherle.io.File(currSrcFile.getCanonicalFile());
                    success = toBeAddedFile.archiveCopyTo((File)new de.schlichtherle.io.File(zipFile, toBeAddedFile.getName()));
                }
                ZipFileUtils.unmount();
            }
            catch (ArchiveException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return success;
    }

    public static boolean addFilesToZip(File[] src, File zipFile) {
        return ZipFileUtils.addFilesToZip(src, zipFile, null);
    }

    private static ArchiveDetector getArchiveDetector(String[] extensions) {
        ArrayList<String> zipFileExtensions = new ArrayList<String>();
        DefaultArchiveDetector detector = null;
        if (extensions != null && extensions.length > 0) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                zipFileExtensions.add(ext);
                zipFileExtensions.add((String)new ZipDriver());
                ++n2;
            }
            detector = new DefaultArchiveDetector(ArchiveDetector.NULL, zipFileExtensions.toArray());
        }
        return detector;
    }

    public static List<ZipEntry> listZipContents(String zipFileName) throws IOException {
        ArrayList<ZipEntry> zipContents = new ArrayList<ZipEntry>();
        ZipFile zipFile = new ZipFile(zipFileName);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            zipContents.add(zipEntries.nextElement());
        }
        return zipContents;
    }

    public static BufferedInputStream openFile(File zipFile, String src, String[] extensions) {
        ArchiveDetector detector = ZipFileUtils.getArchiveDetector(extensions);
        String archiveFileName = zipFile + de.schlichtherle.io.File.separator + src;
        try {
            de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)detector);
            FileInputStream fs = new FileInputStream(archiveFileName);
            BufferedInputStream stream = new BufferedInputStream((InputStream)fs);
            return stream;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void unmount() {
        try {
            de.schlichtherle.io.File.umount();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }

    public static boolean createNewZip(File zipFileToCreate) {
        boolean success = false;
        if (zipFileToCreate.exists()) {
            return true;
        }
        if (!zipFileToCreate.getParentFile().exists()) {
            zipFileToCreate.mkdirs();
        }
        de.schlichtherle.io.File f = new de.schlichtherle.io.File(zipFileToCreate);
        try {
            try {
                success = f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                ZipFileUtils.unmount();
            }
        }
        finally {
            ZipFileUtils.unmount();
        }
        return success;
    }

    public static List<de.schlichtherle.io.File> unzipFiles(File zippedfile, String destPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        ZipFile zipFile = new ZipFile(zippedfile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<de.schlichtherle.io.File> outputFiles = new ArrayList<de.schlichtherle.io.File>();
        de.schlichtherle.io.File destinationFile = new de.schlichtherle.io.File(destPath);
        if (!destinationFile.exists()) {
            destinationFile.mkdirs();
        }
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            de.schlichtherle.io.File outputFile = new de.schlichtherle.io.File((File)destinationFile, entry.getName());
            if (entry.isDirectory() && !outputFile.exists()) {
                outputFile.mkdirs();
                continue;
            }
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            InputStream inputStream = zipFile.getInputStream(entry);
            FileOutputStream outStream = new FileOutputStream((File)outputFile);
            ZipFileUtils.copyByteStream(inputStream, outStream);
            outputFiles.add(outputFile);
            if (monitor != null) {
                monitor.worked(1);
            }
            outStream.close();
            inputStream.close();
        }
        zipFile.close();
        return outputFiles;
    }

    public static void copyByteStream(InputStream in, OutputStream out) throws IOException {
        if (in != null && out != null) {
            int readCount;
            BufferedInputStream inBuffered = new BufferedInputStream(in);
            int bufferSize = 1000;
            byte[] buffer = new byte[bufferSize];
            BufferedOutputStream fout = new BufferedOutputStream(out);
            while ((readCount = inBuffered.read(buffer)) != -1) {
                if (readCount < bufferSize) {
                    fout.write(buffer, 0, readCount);
                    continue;
                }
                fout.write(buffer);
            }
            fout.flush();
            fout.close();
            in.close();
        }
    }
}

