/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.nio.ByteOrder;
import java.util.Collection;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfModuleScope;
import org.eclipse.cdt.debug.edc.internal.symbols.files.BaseExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSection;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.ISymbol;
import org.eclipse.cdt.debug.edc.symbols.IUnmangler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EDCSymbolReader
implements IEDCSymbolReader {
    private static final String[] NO_SOURCE_FILES = new String[0];
    private static final IModuleScope EMPTY_MODULE_SCOPE = new DwarfModuleScope(null);
    private IDebugInfoProvider debugInfoProvider;
    private IExecutableSymbolicsReader exeSymReader;

    public EDCSymbolReader(IExecutableSymbolicsReader exeSymReader, IDebugInfoProvider debugInfoProvider) {
        if (exeSymReader == null) {
            throw new IllegalArgumentException();
        }
        this.exeSymReader = exeSymReader;
        this.debugInfoProvider = debugInfoProvider;
        if (debugInfoProvider != null && !debugInfoProvider.getSymbolFile().equals((Object)exeSymReader.getSymbolFile())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void shutDown() {
        if (this.exeSymReader != null) {
            this.exeSymReader.dispose();
            this.exeSymReader = null;
        }
        if (this.debugInfoProvider != null) {
            this.debugInfoProvider.dispose();
            this.debugInfoProvider = null;
        }
    }

    @Override
    public void dispose() {
        this.exeSymReader.dispose();
    }

    @Override
    public Collection<IExecutableSection> getExecutableSections() {
        return this.exeSymReader.getExecutableSections();
    }

    @Override
    public IExecutableSection findExecutableSection(String sectionName) {
        return this.exeSymReader.findExecutableSection(sectionName);
    }

    @Override
    public Collection<ISection> getSections() {
        return this.exeSymReader.getSections();
    }

    @Override
    public IAddress getBaseLinkAddress() {
        return this.exeSymReader.getBaseLinkAddress();
    }

    @Override
    public long getModificationDate() {
        return this.exeSymReader.getModificationDate();
    }

    @Override
    public Collection<ISymbol> findSymbols(String name) {
        return this.exeSymReader.findSymbols(name);
    }

    @Override
    public Collection<ISymbol> findUnmangledSymbols(String name) {
        return this.exeSymReader.findUnmangledSymbols(name);
    }

    @Override
    public Collection<ISymbol> getSymbols() {
        return this.exeSymReader.getSymbols();
    }

    @Override
    public ISymbol getSymbolAtAddress(IAddress linkAddress) {
        return this.exeSymReader.getSymbolAtAddress(linkAddress);
    }

    @Override
    public IPath getSymbolFile() {
        return this.debugInfoProvider != null ? this.debugInfoProvider.getSymbolFile() : (this.exeSymReader != null ? this.exeSymReader.getSymbolFile() : null);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.exeSymReader.getByteOrder();
    }

    @Override
    public IModuleScope getModuleScope() {
        if (this.debugInfoProvider != null) {
            return this.debugInfoProvider.getModuleScope();
        }
        return EMPTY_MODULE_SCOPE;
    }

    public String[] getSourceFiles() {
        if (this.debugInfoProvider != null) {
            final String[][] resultHolder = new String[1][];
            Job quickParseJob = new Job("Reading Debug Symbol Information: " + this.debugInfoProvider.getSymbolFile().toOSString()){

                protected IStatus run(IProgressMonitor monitor) {
                    String[] sourceFiles = EDCSymbolReader.this.getSourceFiles(monitor);
                    resultHolder[0] = sourceFiles;
                    return Status.OK_STATUS;
                }
            };
            try {
                quickParseJob.schedule();
                quickParseJob.join();
            }
            catch (InterruptedException e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
            return resultHolder[0];
        }
        return NO_SOURCE_FILES;
    }

    public String[] getSourceFiles(IProgressMonitor monitor) {
        if (this.debugInfoProvider != null) {
            return this.debugInfoProvider.getSourceFiles(monitor);
        }
        return NO_SOURCE_FILES;
    }

    @Override
    public boolean hasRecognizedDebugInformation() {
        return this.debugInfoProvider != null;
    }

    public IDebugInfoProvider getDebugInfoProvider() {
        return this.debugInfoProvider;
    }

    public IUnmangler getUnmangler() {
        if (this.exeSymReader instanceof BaseExecutableSymbolicsReader) {
            return ((BaseExecutableSymbolicsReader)this.exeSymReader).getUnmangler();
        }
        return null;
    }
}

