/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.launch;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.launch.ServicesLaunchSequence;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotLaunchSequence;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public abstract class EDCLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public EDCLaunchDelegate() {
        super(false);
    }

    public EDCLaunchDelegate(boolean requireCProject) {
        super(requireCProject);
    }

    /*
     * Loose catch block
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block48: {
            LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.edc.ui.edcActivity", (boolean)true);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Launching...", 10);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                boolean forDebug;
                EDCLaunch edcLaunch;
                block51: {
                    edcLaunch = (EDCLaunch)launch;
                    forDebug = mode.equals("debug");
                    monitor.worked(1);
                    if (edcLaunch.isFirstLaunch()) {
                        edcLaunch.setServiceFactory(this.newServiceFactory());
                        if (forDebug) {
                            edcLaunch.initializeSnapshotSupport();
                        }
                        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
                        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(edcLaunch.getSession(), edcLaunch, (IProgressMonitor)subMon1);
                        edcLaunch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
                        try {
                            this.getOrCancelSequence(servicesLaunchSequence, (IProgressMonitor)subMon1);
                        }
                        catch (InterruptedException e1) {
                            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "Interrupted Exception in dispatch thread.\n" + e1.getLocalizedMessage(), (Throwable)e1));
                        }
                        catch (CancellationException cancellationException) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                        catch (ExecutionException e1) {
                            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in services launch sequence.", e1.getCause()));
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        if (forDebug) {
                            edcLaunch.initializeMemoryRetrieval();
                        }
                        monitor.worked(1);
                    }
                    UncancelableMonitor subMon2 = new UncancelableMonitor(monitor, 4, 4);
                    Sequence finalLaunchSequence = this.getFinalLaunchSequence(edcLaunch.getSession().getExecutor(), edcLaunch, (IProgressMonitor)subMon2);
                    edcLaunch.getSession().getExecutor().execute((Runnable)finalLaunchSequence);
                    boolean succeed = false;
                    try {
                        this.getOrCancelSequence(finalLaunchSequence, (IProgressMonitor)subMon2);
                        succeed = true;
                    }
                    catch (InterruptedException e1) {
                        Status exceptionStatus = new Status(4, "org.eclipse.cdt.debug.edc", 5013, "Interrupted Exception in dispatch thread.\n" + e1.getLocalizedMessage(), (Throwable)e1);
                        if (edcLaunch.isFirstLaunch()) {
                            throw new DebugException((IStatus)exceptionStatus);
                        }
                        EDCDebugger.getMessageLogger().log((IStatus)exceptionStatus);
                        if (!succeed && edcLaunch.isFirstLaunch()) {
                            Query<Object> launchShutdownQuery = new Query<Object>(edcLaunch){
                                private final /* synthetic */ EDCLaunch val$edcLaunch;
                                {
                                    this.val$edcLaunch = eDCLaunch;
                                }

                                protected void execute(DataRequestMonitor<Object> rm) {
                                    this.val$edcLaunch.shutdownSession((RequestMonitor)rm);
                                }
                            };
                            edcLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                            try {
                                launchShutdownQuery.get();
                            }
                            catch (InterruptedException e) {
                                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                            }
                            catch (ExecutionException e) {
                                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                            }
                        }
                        if (!forDebug) {
                            edcLaunch.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
                        }
                        edcLaunch.setLaunching(false);
                        break block48;
                    }
                    catch (CancellationException cancellationException) {
                        block49: {
                            if (edcLaunch.isFirstLaunch()) {
                                throw new CoreException(Status.CANCEL_STATUS);
                            }
                            if (succeed || !edcLaunch.isFirstLaunch()) break block49;
                            Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
                            edcLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                            try {
                                launchShutdownQuery.get();
                            }
                            catch (InterruptedException e) {
                                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                            }
                            catch (ExecutionException e) {
                                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                            }
                        }
                        if (!forDebug) {
                            edcLaunch.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
                        }
                        edcLaunch.setLaunching(false);
                        break block48;
                    }
                    catch (ExecutionException e1) {
                        block50: {
                            IStatus s;
                            Throwable cause = e1.getCause();
                            if (cause instanceof CoreException && (s = ((CoreException)cause).getStatus()).getSeverity() == 8 && edcLaunch.isFirstLaunch()) {
                                throw (CoreException)cause;
                            }
                            IStatus errorStatus = EDCDebugger.getMessageLogger().createStatus(4, null, e1.getCause());
                            if (edcLaunch.isFirstLaunch()) {
                                throw new DebugException(errorStatus);
                            }
                            EDCDebugger.getMessageLogger().log(errorStatus);
                            if (succeed || !edcLaunch.isFirstLaunch()) break block50;
                            {
                                catch (Throwable throwable) {
                                    if (!succeed && edcLaunch.isFirstLaunch()) {
                                        Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
                                        edcLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                                        try {
                                            launchShutdownQuery.get();
                                        }
                                        catch (InterruptedException e) {
                                            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                                        }
                                        catch (ExecutionException e) {
                                            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                                        }
                                    }
                                    if (!forDebug) {
                                        edcLaunch.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
                                    }
                                    edcLaunch.setLaunching(false);
                                    throw throwable;
                                }
                            }
                            Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
                            edcLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                            try {
                                launchShutdownQuery.get();
                            }
                            catch (InterruptedException e) {
                                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                            }
                            catch (ExecutionException e) {
                                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                            }
                        }
                        if (!forDebug) {
                            edcLaunch.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
                        }
                        edcLaunch.setLaunching(false);
                        break block48;
                    }
                    if (succeed || !edcLaunch.isFirstLaunch()) break block51;
                    Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
                    edcLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                    try {
                        launchShutdownQuery.get();
                    }
                    catch (InterruptedException e) {
                        throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                    }
                    catch (ExecutionException e) {
                        throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                    }
                }
                if (!forDebug) {
                    edcLaunch.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
                }
                edcLaunch.setLaunching(false);
            }
            finally {
                monitor.done();
            }
        }
    }

    private Object getOrCancelSequence(Sequence sequence, IProgressMonitor monitor) throws InterruptedException, ExecutionException {
        while (!monitor.isCanceled()) {
            try {
                return sequence.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {}
        }
        sequence.cancel(true);
        throw new CancellationException();
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        EDCLaunch launch = this.findExistingLaunch(configuration, mode);
        if (launch == null) {
            launch = this.createLaunch(configuration, mode);
            launch.initialize();
            launch.setSourceLocator(launch.createSourceLocator());
        } else {
            launch.addAffiliatedLaunchConfiguration(configuration);
            launch.setFirstLaunch(false);
        }
        launch.setActiveLaunchConfiguration(configuration);
        return launch;
    }

    public abstract EDCLaunch createLaunch(ILaunchConfiguration var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EDCLaunch findExistingLaunch(ILaunchConfiguration configuration, String mode) {
        if (!SnapshotUtils.isSnapshotLaunchConfig(configuration)) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            List<ILaunch> launchList = Arrays.asList(manager.getLaunches());
            for (ILaunch iLaunch : launchList) {
                EDCLaunch edcLaunch;
                if (iLaunch.isTerminated() || !(iLaunch instanceof EDCLaunch) || !DsfSession.isSessionActive((String)(edcLaunch = (EDCLaunch)iLaunch).getSession().getId()) || !this.isSameTarget(edcLaunch, configuration, mode)) continue;
                if (edcLaunch.isTerminating()) {
                    this.waitForLaunchToTerminate(edcLaunch);
                }
                EDCLaunch eDCLaunch = edcLaunch;
                synchronized (eDCLaunch) {
                    if (!edcLaunch.isTerminating()) {
                        edcLaunch.setLaunching(true);
                        return edcLaunch;
                    }
                }
            }
        }
        return null;
    }

    private void waitForLaunchToTerminate(final EDCLaunch edcLaunch) {
        Job waitForTerminate = new Job("Waiting for " + edcLaunch.getDescription() + " to terminate"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Waiting for termination", -1);
                try {
                    while (!edcLaunch.isTerminated()) {
                        Thread.sleep(500L);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            monitor.worked(1);
                            continue;
                        }
                        catch (InterruptedException e) {
                            EDCDebugger.getMessageLogger().logError(null, e);
                        }
                        break;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        waitForTerminate.schedule();
        try {
            waitForTerminate.join();
        }
        catch (InterruptedException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    public abstract String getDebugModelID();

    protected abstract Sequence getLiveLaunchSequence(DsfExecutor var1, EDCLaunch var2, IProgressMonitor var3);

    protected Sequence getSnapshotLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        return new SnapshotLaunchSequence(executor, launch, pm);
    }

    protected Sequence getFinalLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        if (launch.isSnapshotLaunch()) {
            return this.getSnapshotLaunchSequence(executor, launch, pm);
        }
        return this.getLiveLaunchSequence(executor, launch, pm);
    }

    protected abstract IDsfDebugServicesFactory newServiceFactory();

    protected abstract boolean isSameTarget(EDCLaunch var1, ILaunchConfiguration var2, String var3);

    class UncancelableMonitor
    extends SubProgressMonitor {
        private boolean canceled;

        public UncancelableMonitor(IProgressMonitor monitor, int ticks, int style) {
            super(monitor, ticks, style);
            this.canceled = false;
        }

        public void setCanceled(boolean b) {
            this.canceled = b;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }
}

