/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import org.tizen.dynamicanalyzer.util.ByteUtil;
import org.tizen.dynamicanalyzer.util.UnsignedInt;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class ProtocolParser {
    private final int Md5StringLengt = 32;
    protected int index = 0;
    protected byte[] body = null;

    public ProtocolParser() {
    }

    public ProtocolParser(byte[] msg) {
        this.body = msg;
    }

    public final int getIndex() {
        return this.index;
    }

    public final char getChar() {
        char c = (char)this.body[this.index];
        ++this.index;
        return c;
    }

    public final boolean getBoolean() {
        boolean b = this.body[this.index] != 0;
        ++this.index;
        return b;
    }

    public final int getShort() {
        byte[] temp = new byte[4];
        System.arraycopy(this.body, this.index, temp, 0, 2);
        int ret = ByteUtil.toInt((byte[])temp, (int)0);
        this.index += 2;
        return ret;
    }

    public final int getInt() {
        int ret = ByteUtil.toInt((byte[])this.body, (int)this.index);
        this.index += 4;
        return ret;
    }

    public final UnsignedInt getUnsignedInt() {
        UnsignedInt ret = ByteUtil.toUnsignedInt((byte[])this.body, (int)this.index);
        this.index += 4;
        return ret;
    }

    public final long getLong() {
        long ret = ByteUtil.toLong((byte[])this.body, (int)this.index);
        this.index += 8;
        return ret;
    }

    public final float getFloat() {
        float ret = ByteUtil.toFloat((byte[])this.body, (int)this.index);
        this.index += 4;
        return ret;
    }

    public final double getDouble() {
        double ret = ByteUtil.toDouble((byte[])this.body, (int)this.index);
        this.index += 8;
        return ret;
    }

    public final String getString() {
        int length = this.getStringLength();
        String ret = length > 1 ? new String(this.body, this.index, length - 1) : "";
        this.index += length;
        return ret;
    }

    public final String getMd5String() {
        int length = 32;
        String ret = length > 1 ? new String(this.body, this.index, length - 1) : "";
        this.index += length;
        return ret;
    }

    public final byte[] getBytesN(int size) {
        byte[] ret = ByteUtil.toBytesN((byte[])this.body, (int)this.index, (int)size);
        this.index += size;
        return ret;
    }

    private int getStringLength() {
        int length = 0;
        int i = this.index;
        while (i < this.body.length) {
            if (this.body[i] == 0) {
                ++length;
                break;
            }
            ++i;
            ++length;
        }
        return length;
    }

    public final String getByteString(int size) {
        String ret = new String(this.body, this.index, size);
        this.index += size;
        return ret;
    }

    public final String parseArgs() {
        int countOfArgs = this.getInt();
        StringBuffer buffer = new StringBuffer();
        int ii = 0;
        while (ii < countOfArgs) {
            this.parseSingleArg(buffer);
            if (ii + 1 != countOfArgs) {
                buffer.append(",").append(" ");
            }
            ++ii;
        }
        return buffer.toString();
    }

    public String parseReturn() {
        StringBuffer buffer = new StringBuffer();
        this.parseSingleArg(buffer);
        return buffer.toString();
    }

    private void parseSingleArg(StringBuffer buffer) {
        char c = this.getChar();
        block0 : switch (c) {
            case 'c': {
                buffer.append(this.getChar());
                break;
            }
            case 'd': {
                int iValue = this.getInt();
                buffer.append(iValue);
                break;
            }
            case 'x': {
                long lValue = this.getLong();
                buffer.append(lValue);
                break;
            }
            case 'p': {
                long pValue = this.getLong();
                buffer.append(AnalyzerUtil.toHexdecimal(pValue));
                break;
            }
            case 'f': {
                float fValue = this.getFloat();
                buffer.append(fValue);
                break;
            }
            case 'w': {
                double dValue = this.getDouble();
                buffer.append(dValue);
                break;
            }
            case 'b': {
                byte b = this.body[this.index++];
                if (b == 0) {
                    buffer.append("false");
                    break;
                }
                buffer.append("true");
                break;
            }
            case 's': {
                int iii = this.index;
                while (iii < this.body.length) {
                    if (this.body[iii] == 0) {
                        this.index = iii + 1;
                        break block0;
                    }
                    buffer.append((char)this.body[iii]);
                    ++iii;
                }
                break;
            }
            case 'F': {
                long object = this.getLong();
                buffer.append(AnalyzerUtil.toHexdecimal(object));
                int arrarySize = this.getInt();
                buffer.append("[");
                int i = 0;
                while (i < arrarySize) {
                    float fValue = this.getFloat();
                    buffer.append(fValue);
                    if (i != arrarySize - 1) {
                        buffer.append(",");
                    }
                    ++i;
                }
                buffer.append("]");
            }
        }
    }
}

