/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.control.ProgressTable;
import org.tizen.dynamicanalyzer.control.ResourceMonitor;
import org.tizen.dynamicanalyzer.database.DBTableRegistry;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.MenuBarLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.communicator.DataChannelThread;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.logparser.LogParser;
import org.tizen.dynamicanalyzer.swap.logparser.MessageParser;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotTimer;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.page.UpdateViewTimer;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableRegistry;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class StartTraceManager
implements Runnable {
    private static final int PROCINFO_WAIT_TIME = 5000;
    private ProgressTable.STAGE lastStage = ProgressTable.STAGE.NONE;
    private boolean cancelAction = false;
    private ProgressHolder progress;
    private Thread startThread = null;
    private IProgress initProgress = new IProgress(){

        @Override
        public boolean isCanceled() {
            return StartTraceManager.this.cancelAction;
        }

        @Override
        public void setStageComplete(ProgressTable.STAGE stage) {
            StartTraceManager.this.lastStage = stage;
            int percent = ProgressTable.getPercent(ProgressTable.PHASE.TRACE_START, StartTraceManager.this.lastStage);
            StartTraceManager.this.setProgressPercent(percent);
        }

        @Override
        public boolean testCancel() {
            return StartTraceManager.this.testCancel();
        }

        @Override
        public void run() {
        }
    };
    private IProgress startProgress = new IProgress(){

        @Override
        public boolean isCanceled() {
            return StartTraceManager.this.cancelAction;
        }

        @Override
        public void setStageComplete(ProgressTable.STAGE stage) {
            StartTraceManager.this.lastStage = stage;
            int percent = ProgressTable.getPercent(ProgressTable.PHASE.TRACE_START, StartTraceManager.this.lastStage);
            StartTraceManager.this.setProgressPercent(percent);
        }

        @Override
        public boolean testCancel() {
            return StartTraceManager.this.testCancel();
        }

        @Override
        public void run() {
            if (Global.isGUIMode()) {
                Toolbar.INSTANCE.startTimer();
                UpdateViewTimer.start();
            }
            StartTraceManager.this.startDlog();
        }
    };

    public StartTraceManager() {
        if (Global.isGUIMode()) {
            DATableRegistry.clearFiltering();
            this.createProgressDialog();
        }
    }

    private void createProgressDialog() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StartTraceManager.this.progress = ProgressManager.INSTANCE.createProgress(false, 1, AnalyzerLabels.DLG_PREPARE_TRACE, AnalyzerLabels.DLG_PLEASE_WAIT, new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent arg0) {
                        StartTraceManager.this.cancelAction = true;
                        if (StartTraceManager.this.startThread != null) {
                            StartTraceManager.this.startThread.interrupt();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void run() {
        this.startThread = Thread.currentThread();
        DAResult result = this.setup();
        if (this.lastStage == ProgressTable.STAGE.FINAL && result.isSuccess()) {
            DAState.changeCurrentState(DAState.RUNNING);
        } else {
            DAState.changeCurrentState(DAState.PREPARE_CANCEL);
            if (!this.cleanup()) {
                result = new DAResult(DAResult.ErrorCode.ERR_CANCEL_FAILED);
            }
        }
        if (this.progress != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.INSTANCE.stopProgress(StartTraceManager.this.progress);
                }
            });
        }
        if (!result.isSuccess() && result.getErrorCode() != DAResult.ErrorCode.ERR_BY_USER_CANCEL) {
            UIActionHolder.getUIAction().showWarning(result);
        }
        if (Global.isGUIMode()) {
            ShortCutManager.getInstance().setEnabled(true);
            Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
        }
    }

    private DAResult setup() {
        ProgressTable.STAGE[] sTAGEArray = ProgressTable.PHASE.TRACE_START.stageArray;
        int n = ProgressTable.PHASE.TRACE_START.stageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressTable.STAGE stage = sTAGEArray[n2];
            DAResult result = this.setupStage(stage);
            if (!result.isSuccess()) {
                return result;
            }
            if (!this.setStageComplete(stage)) {
                return new DAResult(DAResult.ErrorCode.ERR_BY_USER_CANCEL);
            }
            ++n2;
        }
        return DAResult.SUCCESS;
    }

    private DAResult setupStage(ProgressTable.STAGE stage) {
        boolean result = true;
        Logger.info((Object)(String.valueOf(stage.name()) + " started"));
        switch (stage) {
            case CHECK_DEV: {
                result = CommonAction.checkDeviceValidness();
                break;
            }
            case CHECK_APP: {
                result = CommonAction.checkApplicationValidness();
                break;
            }
            case CHECK_CONFIG: {
                result = CommonAction.checkConfiguration();
                break;
            }
            case RESET_UI: {
                CommonAction.clear();
                this.resetUI(Global.getProject());
                break;
            }
            case CREATE_PROJECT: {
                Project project = this.createProject();
                Global.setProject(project);
                if (project != null) break;
                return new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            }
            case ESTABLISH_DB: {
                SqlConnectionManager.closeConnection();
                result = this.establishDBConnection(String.valueOf(Global.getProject().getSavePath()) + File.separator + "da.trace");
                if (!this.initProgress.testCancel()) break;
                return new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            }
            case CREATE_DBTABLE: {
                DBTableRegistry.createDBTables(null);
                if (!this.initProgress.testCancel()) break;
                return new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            }
            case CREATE_DATATHREAD: {
                result = DataChannelThread.getInstance().start();
                break;
            }
            case CREATE_MESSAGEPARSER: {
                result = MessageParser.getInstance().start();
                break;
            }
            case CREATE_LOGPARSER: {
                result = LogParser.getInstance().start();
                break;
            }
            case CREATE_PAGEMANAGER: {
                DataManagerRegistry.startThreads();
                break;
            }
            case START_RESOURCE_MONITOR: {
                ResourceMonitor.start();
                break;
            }
            case SEND_STARTMSG: {
                DAResult ret = DACommunicator.startTrace(this.startProgress);
                if (!ret.isSuccess() && this.testCancel()) {
                    ret = new DAResult(DAResult.ErrorCode.ERR_BY_USER_CANCEL);
                }
                return ret;
            }
            case WAIT_PROCINFO: {
                try {
                    result = this.waitProcInfo(5000);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    return new DAResult(DAResult.ErrorCode.ERR_BY_USER_CANCEL);
                }
            }
            case CREATE_SCREENSHOT_TIMER: {
                FlatPreferences pref = FlatPreferences.SCREENSHOT_PERIODICALLY;
                int value = SettingDataManager.INSTANCE.getPreferenceValue(pref);
                if (value <= 0 || !SettingDataManager.INSTANCE.isFlatFeatureSelected(FlatFeature.SCREENSHOT)) break;
                ScreenshotTimer.start(value);
                break;
            }
            default: {
                return DAResult.SUCCESS;
            }
        }
        return result ? DAResult.SUCCESS : new DAResult(stage.errCode);
    }

    private boolean establishDBConnection(String path) {
        CompletableFuture<Void> task = CompletableFuture.runAsync(() -> SqlConnectionManager.establishConnection(path));
        try {
            task.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logger.error((Object)e);
            return false;
        }
        return true;
    }

    private Project createProject() {
        Project project = new Project();
        project.init(this.initProgress);
        project.setMempsAvailable(Global.getCurrentDeviceInfo().getMempAvailable());
        return project;
    }

    private void resetUI(Project project) {
        if (UILayoutDataManager.INSTANCE.isDirty()) {
            UIActionHolder.getUIAction().setUIElementsBySetting();
        }
        UIActionHolder.getUIAction().applyStartTraceUI();
        if (project == null) {
            UIActionHolder.getUIAction().applyWebProfilingUI(false);
        } else {
            UIActionHolder.getUIAction().applyWebProfilingUI(project.isWebApplication());
        }
    }

    private void disableMenuItems() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_NEW, false);
                MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_LOAD, false);
            }
        });
    }

    private boolean waitProcInfo(int millis) throws InterruptedException {
        if (Global.isGUIMode()) {
            this.disableMenuItems();
        }
        int waittime = 0;
        while (waittime <= millis && !AnalyzerManager.isProcessInfoArrived()) {
            Thread.sleep(100L);
            waittime += 100;
        }
        return waittime <= millis;
    }

    private boolean cleanup() {
        DAState.changeCurrentState(DAState.PREPARE_CANCEL);
        List<ProgressTable.STAGE> stages = Arrays.asList(ProgressTable.PHASE.TRACE_START.stageArray);
        int i = stages.indexOf((Object)this.lastStage);
        while (i >= 0) {
            this.unwind(stages.get(i));
            --i;
        }
        CommonAction.clear();
        DAState.changeCurrentState(DAState.INIT);
        return !Thread.interrupted();
    }

    private void unwind(ProgressTable.STAGE stage) {
        switch (stage) {
            case CREATE_SCREENSHOT_TIMER: {
                ScreenshotTimer.stop();
                break;
            }
            case SEND_STARTMSG: {
                DACommunicator.stopTrace();
                break;
            }
            case START_RESOURCE_MONITOR: {
                if (Global.isGUIMode()) {
                    Toolbar.INSTANCE.stopTimer();
                }
                UpdateViewTimer.stop();
                ResourceMonitor.stop();
                break;
            }
            case CREATE_PAGEMANAGER: {
                DataManagerRegistry.stopThreadsForced();
                break;
            }
            case CREATE_LOGPARSER: {
                LogParser.getInstance().stopForced();
                break;
            }
            case CREATE_MESSAGEPARSER: {
                MessageParser.getInstance().stopForced();
                break;
            }
            case CREATE_DATATHREAD: {
                DataChannelThread.getInstance().stopForced();
                break;
            }
        }
        this.setCancelProgress(stage);
    }

    private void setProgressPercent(int percent) {
        final int per = percent;
        if (this.progress != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    StartTraceManager.this.progress.setValue(per);
                }
            });
        }
    }

    private boolean setStageComplete(ProgressTable.STAGE st) {
        this.lastStage = st;
        int percent = ProgressTable.getPercent(ProgressTable.PHASE.TRACE_START, this.lastStage);
        Logger.debug((Object)("done stage: " + (Object)((Object)st) + "; percent = " + percent));
        if (percent != 100 && this.testCancel()) {
            return false;
        }
        this.setProgressPercent(percent);
        return true;
    }

    private void setCancelProgress(ProgressTable.STAGE st) {
        if (st == this.lastStage) {
            return;
        }
        int percent = ProgressTable.getPercent(ProgressTable.PHASE.TRACE_START, st);
        this.setProgressPercent(percent);
    }

    private boolean testCancel() {
        return Thread.interrupted() || AnalyzerManager.isExit();
    }

    private void startDlog() {
        Thread DlogThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DLogDataManager.getInstance().startDlog();
            }
        }, "StartDlogThread");
        DlogThread.start();
    }
}

