/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.model;

public class DATime {
    private int sec;
    private int nano;

    public DATime() {
        this.sec = 0;
        this.nano = 0;
    }

    public DATime(int sec, int nano) {
        this.sec = sec;
        this.nano = nano;
    }

    public DATime(String timestring) {
        this.fromString(timestring);
    }

    public int getSec() {
        return this.sec;
    }

    public void setSec(int sec) {
        this.sec = sec;
    }

    public int getNano() {
        return this.nano;
    }

    public void setNano(int nano) {
        this.nano = nano;
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.sec)) + "-" + Integer.toString(this.nano);
    }

    public void fromString(String saveData) {
        String[] splitData = saveData.split("-");
        this.sec = Integer.parseInt(splitData[0]);
        this.nano = Integer.parseInt(splitData[1]);
    }

    public long getLongTime() {
        long ret = 0L;
        long secLong = (long)this.sec * 1000000L;
        long nanoLong = this.nano / 1000;
        ret = secLong + nanoLong;
        return ret;
    }

    public static DATime getDATimeFromLong(long time) {
        long seclong = time / 1000000L;
        long nanolong = time % 1000000L * 1000L;
        return new DATime((int)seclong, (int)nanolong);
    }

    public DATime subtract(DATime operand) {
        int tsec = this.sec - operand.getSec();
        int tnano = this.nano - operand.getNano();
        if (tnano < 0) {
            --tsec;
            tnano += 1000000000;
        }
        return new DATime(tsec, tnano);
    }
}

