/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

public class LibraryObject {
    private final int binaryID;
    private final long lowestAddress;
    private final long highestAddress;

    public LibraryObject(int id, long low, long high) {
        this.binaryID = id;
        this.lowestAddress = low;
        this.highestAddress = high;
    }

    public long getLowestAddress() {
        return this.lowestAddress;
    }

    public long getHighestAddress() {
        return this.highestAddress;
    }

    public int getBinaryID() {
        return this.binaryID;
    }

    private static boolean isAddrInRange(long addr, long low, long high) {
        return low <= addr && addr < high;
    }

    public boolean isAddrInRange(long addr) {
        return LibraryObject.isAddrInRange(addr, this.lowestAddress, this.highestAddress);
    }

    public boolean isOverlapped(long low, long high) {
        if (low >= high) {
            return false;
        }
        return LibraryObject.isAddrInRange(this.lowestAddress, low, high) || LibraryObject.isAddrInRange(this.highestAddress, low + 1L, high + 1L) || this.lowestAddress <= low && high <= this.highestAddress;
    }

    public boolean isOverlapped(LibraryObject other) {
        return this.isOverlapped(other.lowestAddress, other.highestAddress);
    }
}

