/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.data.MemoryMapDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessMemoryMap {
    private static final String WHERE_PID_TIME = "where " + MemoryMapDBTable.COLUMN.PID.name + "=%d and " + MemoryMapDBTable.COLUMN.CAPTIME.name + "=%d";
    private int pid;
    private long capturedTime = -1L;
    protected LibraryObject mainBinary = null;
    protected NavigableMap<Long, LibraryObject> binaryByAddress = new TreeMap<Long, LibraryObject>();
    protected Map<Integer, NavigableMap<Long, LibraryObject>> binaryByBinaryID = new HashMap<Integer, NavigableMap<Long, LibraryObject>>();

    public ProcessMemoryMap(int pid, long time) {
        this.pid = pid;
        this.capturedTime = time;
    }

    public long getCapturedTime() {
        return this.capturedTime;
    }

    public void setCapturedTime(long time) {
        this.capturedTime = time;
    }

    public void setMainBinary(LibraryObject libobj) {
        this.mainBinary = libobj;
        this.addLibraryMap(libobj);
    }

    public LibraryObject getMainbinary() {
        return this.mainBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLibraryMap(LibraryObject libobj) {
        long lowaddr = libobj.getLowestAddress();
        int binid = libobj.getBinaryID();
        NavigableMap<Long, LibraryObject> navigableMap = this.binaryByAddress;
        synchronized (navigableMap) {
            block7: {
                Map.Entry<Long, LibraryObject> rightEntry;
                block6: {
                    Map.Entry<Long, LibraryObject> leftEntry = this.binaryByAddress.floorEntry(lowaddr);
                    rightEntry = this.binaryByAddress.ceilingEntry(lowaddr);
                    if (leftEntry == null || !leftEntry.getValue().isOverlapped(libobj)) break block6;
                    return false;
                }
                if (rightEntry == null || !rightEntry.getValue().isOverlapped(libobj)) break block7;
                return false;
            }
            this.binaryByAddress.put(lowaddr, libobj);
            NavigableMap<Long, LibraryObject> libMap = this.binaryByBinaryID.get(binid);
            if (libMap == null) {
                libMap = new TreeMap<Long, LibraryObject>();
                this.binaryByBinaryID.put(binid, libMap);
            }
            libMap.put(lowaddr, libobj);
        }
        return true;
    }

    public LibraryObject getLibraryByAddress(long address) {
        Map.Entry<Long, LibraryObject> entry = this.binaryByAddress.floorEntry(address);
        if (entry != null) {
            LibraryObject libobj = entry.getValue();
            return libobj.isAddrInRange(address) ? libobj : null;
        }
        return null;
    }

    public NavigableMap<Long, LibraryObject> getLibraryMappingByBinaryID(int binaryID) {
        return this.binaryByBinaryID.get(binaryID);
    }

    private static boolean isAddrInRange(long addr, long low, long high) {
        return low <= addr && addr < high;
    }

    private static String getLibraryPath(int binID) {
        return Global.getProject().getDeviceStatusInfo().getBinaryInfo(binID).getTargetBinaryPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMapping(long lowaddr, long highaddr) {
        boolean changed = false;
        NavigableMap<Long, LibraryObject> navigableMap = this.binaryByAddress;
        synchronized (navigableMap) {
            Map.Entry<Long, LibraryObject> curEntry = this.binaryByAddress.floorEntry(lowaddr);
            if (curEntry == null || !curEntry.getValue().isOverlapped(lowaddr, highaddr)) {
                curEntry = this.binaryByAddress.ceilingEntry(lowaddr);
            }
            while (curEntry != null && curEntry.getValue().isOverlapped(lowaddr, highaddr)) {
                LibraryObject curLib = curEntry.getValue();
                int binid = curLib.getBinaryID();
                long curLow = curLib.getLowestAddress();
                long curHigh = curLib.getHighestAddress();
                boolean leftTouched = ProcessMemoryMap.isAddrInRange(curLow, lowaddr, highaddr);
                boolean rightTouched = ProcessMemoryMap.isAddrInRange(curHigh, lowaddr, highaddr + 1L);
                this.binaryByAddress.remove(curLow);
                this.binaryByBinaryID.get(binid).remove(curLow);
                changed = true;
                if (leftTouched && rightTouched) {
                    if (this.binaryByBinaryID.get(binid).size() == 0) {
                        this.binaryByBinaryID.remove(binid);
                    }
                    Logger.info((String)"Removed mapping for %s", (Object[])new Object[]{ProcessMemoryMap.getLibraryPath(binid)});
                } else if (!leftTouched && !rightTouched) {
                    LibraryObject leftLib = new LibraryObject(binid, curLow, lowaddr);
                    LibraryObject rightLib = new LibraryObject(binid, highaddr, curHigh);
                    this.binaryByAddress.put(curLow, leftLib);
                    this.binaryByAddress.put(highaddr, rightLib);
                    this.binaryByBinaryID.get(binid).put(curLow, leftLib);
                    this.binaryByBinaryID.get(binid).put(highaddr, rightLib);
                    Logger.info((String)"Splitted mapping for %s", (Object[])new Object[]{ProcessMemoryMap.getLibraryPath(binid)});
                } else {
                    if (rightTouched) {
                        curHigh = lowaddr;
                    } else {
                        curLow = highaddr;
                    }
                    LibraryObject newLib = new LibraryObject(binid, curLow, curHigh);
                    this.binaryByAddress.put(curLow, newLib);
                    this.binaryByBinaryID.get(binid).put(curLow, newLib);
                    Logger.info((String)"Shrinked mapping for %s", (Object[])new Object[]{ProcessMemoryMap.getLibraryPath(binid)});
                }
                curEntry = this.binaryByAddress.ceilingEntry(curHigh);
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(ProcessMemoryMap srcMap) {
        this.mainBinary = srcMap.mainBinary;
        NavigableMap<Long, LibraryObject> navigableMap = this.binaryByAddress;
        synchronized (navigableMap) {
            this.binaryByAddress.putAll(srcMap.binaryByAddress);
            this.binaryByBinaryID.putAll(srcMap.binaryByBinaryID);
        }
    }

    public void saveMemoryMap(DBTable table) {
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        for (Map.Entry entry : this.binaryByAddress.entrySet()) {
            ArrayList<Serializable> data = new ArrayList<Serializable>();
            LibraryObject lib = (LibraryObject)entry.getValue();
            data.add(Integer.valueOf(this.pid));
            data.add(Long.valueOf(this.capturedTime));
            data.add(Long.valueOf(lib.getLowestAddress()));
            data.add(Long.valueOf(lib.getHighestAddress()));
            data.add(Integer.valueOf(lib.getBinaryID()));
            if (lib == this.mainBinary) {
                data.add(Boolean.valueOf(true));
            } else {
                data.add(Boolean.valueOf(false));
            }
            datas.add(data);
        }
        table.insertData(datas);
    }

    public void openMemoryMap(DBTable table) {
        this.binaryByAddress.clear();
        this.binaryByBinaryID.clear();
        String where = String.format(WHERE_PID_TIME, this.pid, this.capturedTime);
        List<List<Object>> memdatas = table.selectAllColumnData(where);
        if (memdatas != null) {
            int rsize = memdatas.size();
            int i = 0;
            while (i < rsize) {
                List<Object> memdata = memdatas.get(i);
                long lowaddr = (Long)memdata.get(2);
                long highaddr = (Long)memdata.get(3);
                int binaryID = (Integer)memdata.get(4);
                boolean mainornot = (Boolean)memdata.get(5);
                LibraryObject obj = new LibraryObject(binaryID, lowaddr, highaddr);
                if (mainornot) {
                    this.setMainBinary(obj);
                } else {
                    this.addLibraryMap(obj);
                }
                ++i;
            }
        }
    }

    public Map<Long, LibraryObject> getAllMappings() {
        return this.binaryByAddress;
    }
}

