/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmDatetimeProperties
extends HierarchyUIObjectProperties {
    private String format;
    private int sec;
    private int min;
    private int hour;
    private int mday;
    private int mon;
    private int year;
    private int wday;
    private int yday;

    public ElmDatetimeProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.format = parser.getString();
        this.sec = parser.getInt();
        this.min = parser.getInt();
        this.hour = parser.getInt();
        this.mday = parser.getInt();
        this.mon = parser.getInt() + 1;
        this.year = parser.getInt() + 1900;
        this.wday = parser.getInt();
        this.yday = parser.getInt();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("format", this.format));
        properties.add(new PropertyValue("seconds", Integer.toString(this.sec)));
        properties.add(new PropertyValue("minutes", Integer.toString(this.min)));
        properties.add(new PropertyValue("hours", Integer.toString(this.hour)));
        properties.add(new PropertyValue("day", Integer.toString(this.mday)));
        properties.add(new PropertyValue("month", Integer.toString(this.mon)));
        properties.add(new PropertyValue("year", Integer.toString(this.year)));
        properties.add(new PropertyValue("day of week", this.getDayOfWeekMessage(this.wday)));
        properties.add(new PropertyValue("days in year", Integer.toString(this.yday)));
        return properties;
    }

    private String getDayOfWeekMessage(int code) {
        switch (code) {
            case 0: {
                return "SUN";
            }
            case 1: {
                return "MON";
            }
            case 2: {
                return "TUE";
            }
            case 3: {
                return "WED";
            }
            case 4: {
                return "THU";
            }
            case 5: {
                return "FRI";
            }
            case 6: {
                return "SAT";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

