/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmGenlistProperties
extends HierarchyUIObjectProperties {
    private boolean multiSelect;
    private String mode;
    private int itemCount;
    private boolean homogeneous;
    private int blockCount;
    private double longpressTimeout;
    private boolean reorderMode;
    private boolean decorateMode;
    private boolean treeEffectEnabled;
    private String selectMode;
    private boolean highlightMode;
    private boolean realizationMode;

    public ElmGenlistProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.multiSelect = parser.getBoolean();
        this.mode = this.getModeMessage(parser.getChar());
        this.itemCount = parser.getInt();
        this.homogeneous = parser.getBoolean();
        this.blockCount = parser.getInt();
        this.longpressTimeout = parser.getFloat();
        this.reorderMode = parser.getBoolean();
        this.decorateMode = parser.getBoolean();
        this.treeEffectEnabled = parser.getBoolean();
        this.selectMode = this.getSelectModeMessage(parser.getChar());
        this.highlightMode = parser.getBoolean();
        this.realizationMode = parser.getBoolean();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("mode", this.mode));
        properties.add(new PropertyValue("selectMode", this.selectMode));
        properties.add(new PropertyValue("multiSelect", Boolean.toString(this.multiSelect)));
        properties.add(new PropertyValue("itemCount", Integer.toString(this.itemCount)));
        properties.add(new PropertyValue("blockCount", Integer.toString(this.blockCount)));
        properties.add(new PropertyValue("homogeneous", Boolean.toString(this.homogeneous)));
        properties.add(new PropertyValue("longpressTimeout", Double.toString(this.longpressTimeout)));
        properties.add(new PropertyValue("reorderMode", Boolean.toString(this.reorderMode)));
        properties.add(new PropertyValue("decorateMode", Boolean.toString(this.decorateMode)));
        properties.add(new PropertyValue("treeEffectEnabled", Boolean.toString(this.treeEffectEnabled)));
        properties.add(new PropertyValue("highlightMode", Boolean.toString(this.highlightMode)));
        properties.add(new PropertyValue("realizationMode", Boolean.toString(this.realizationMode)));
        return properties;
    }

    private String getSelectModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_OBJECT_SELECT_MODE_DEFAULT";
            }
            case 1: {
                return "ELM_OBJECT_SELECT_MODE_ALWAYS";
            }
            case 2: {
                return "ELM_OBJECT_SELECT_MODE_NONE";
            }
            case 3: {
                return "ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY";
            }
            case 4: {
                return "ELM_OBJECT_SELECT_MODE_MAX";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_LIST_COMPRESS";
            }
            case 1: {
                return "ELM_LIST_SCROLL";
            }
            case 2: {
                return "ELM_LIST_LIMIT";
            }
            case 3: {
                return "ELM_LIST_EXPAND";
            }
            case 4: {
                return "ELM_LIST_LAST";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

