/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.layout;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.UIHierarchyPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyViewCommunication;
import org.tizen.dynamicanalyzer.ui.hierarchy.layout.HierarchyLayoutFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeView;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class HierarchyLayoutView
extends DAViewComposite {
    public static final String ID = HierarchyLayoutView.class.getName();
    private HierarchyLayoutFigure layoutFigure;

    public HierarchyLayoutView(Composite parent, int style, HierarchyTreeView sourceView) {
        super(parent, style, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(UIHierarchyPageLabels.UIHIERARCHY_LAYOUT_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setLayout((Layout)new FillLayout());
        Canvas canvas = new Canvas(contents, 0x20000800);
        canvas.setBackground(ColorResources.TREEVIEW_BG);
        LightweightSystem overviewLWS = new LightweightSystem(canvas);
        this.layoutFigure = new HierarchyLayoutFigure();
        this.layoutFigure.setSource((IFigure)sourceView.getTreeLayer());
        overviewLWS.setContents((IFigure)this.layoutFigure);
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData && data.getData() instanceof HierarchyViewCommunication) {
            HierarchyViewCommunication param = (HierarchyViewCommunication)data.getData();
            switch (param.getAction()) {
                case NODE_SELECT: 
                case NODE_UNSELECT: 
                case TREE_RESTRUCT: {
                    this.layoutFigure.setSelectedUIObj(param.getUIObj());
                    this.layoutFigure.repaint();
                    break;
                }
            }
        }
    }
}

