/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeFigure;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyZoomManager;

public class HierarchyTreeBranchLayout
extends AbstractLayout {
    private static final int DISTANCE = 12;
    private int pointOfContact;

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(HierarchyZoomManager.INSTANCE.getScaled(container.getInsets().getWidth()), container.getInsets().getHeight());
        return result.getSize();
    }

    private int[] calculateNewRightContour(int[] old, int[] add, int shift) {
        if (old == null) {
            return add;
        }
        int[] result = new int[Math.max(old.length, add.length)];
        System.arraycopy(add, 0, result, 0, add.length);
        int i = add.length;
        while (i < result.length) {
            result[i] = old[i] + shift;
            ++i;
        }
        return result;
    }

    private int calculateOverlap(int[] leftSubtree, int[] rightSubtree) {
        this.pointOfContact = 0;
        if (leftSubtree == null) {
            return 0;
        }
        int min = Math.min(leftSubtree.length, rightSubtree.length);
        int result = Integer.MAX_VALUE;
        int i = 0;
        while (i < min) {
            int current = leftSubtree[i] + rightSubtree[i];
            if (i > 0) {
                current -= 5;
            }
            if (current < result) {
                result = current;
                this.pointOfContact = i + 1;
            }
            ++i;
        }
        return result;
    }

    public void layout(IFigure container) {
        List subtrees = container.getChildren();
        int[] rightContour = null;
        int previousSubtreeDepth = 0;
        int distance = HierarchyZoomManager.INSTANCE.getScaled(12);
        Point reference = container.getBounds().getLocation();
        Point currentXY = reference.getCopy();
        int i = 0;
        while (i < subtrees.size()) {
            HierarchyTreeFigure subtree = (HierarchyTreeFigure)((Object)subtrees.get(i));
            Dimension subtreeSize = subtree.getPreferredSize();
            subtree.setSize(subtreeSize);
            int[] leftContour = subtree.getContourLeft();
            int overlap = this.calculateOverlap(rightContour, leftContour);
            int contactDepth = this.pointOfContact;
            subtree.setLocation(currentXY.getTranslated(0, -overlap));
            int advance = distance + subtreeSize.height - overlap;
            rightContour = this.calculateNewRightContour(rightContour, subtree.getContourRight(), advance);
            currentXY.y += advance;
            int shiftRight = reference.y - subtree.getBounds().y;
            if (shiftRight > 0) {
                currentXY.y += shiftRight;
                Point correction = new Point(0, shiftRight);
                int j = 0;
                while (j <= i) {
                    ((IFigure)subtrees.get(j)).translate(correction.x, correction.y);
                    ++j;
                }
            }
            if (contactDepth > previousSubtreeDepth) {
                HierarchyTreeFigure branch = (HierarchyTreeFigure)((Object)subtrees.get(i - 1));
                int slack = subtree.getBounds().y - branch.getBounds().bottom() - distance + this.calculateOverlap(branch.getContourRight(), subtree.getContourLeft());
                int end = i;
                int begin = end - 1;
                while (begin > 0 && ((HierarchyTreeFigure)((Object)subtrees.get(begin))).getDepth() < contactDepth) {
                    --begin;
                }
                int j = begin + 1;
                while (j < end) {
                    branch = (HierarchyTreeFigure)((Object)subtrees.get(j));
                    Point shift = new Point(0, slack * (j - begin) / (end - begin));
                    branch.translate(shift.x, shift.y);
                    ++j;
                }
            }
            previousSubtreeDepth = subtree.getDepth();
            ++i;
        }
    }
}

