/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.score;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;

public class ScoreView
extends DAViewComposite {
    private Canvas scoreBoard = null;
    private Canvas scoreInfo = null;
    private int failCount = 0;
    private int leakSize = 0;
    private int warningSize = 0;
    private int electricEnergy = 0;
    private int score = 99;
    private List<Image> scoreImage = null;
    private List<String> columnString = null;
    private List<Integer> columnValue = null;

    public ScoreView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        if (this.scoreImage == null) {
            this.scoreImage = new ArrayList<Image>();
            this.scoreImage.add(ImageResources.SCORE_0);
            this.scoreImage.add(ImageResources.SCORE_1);
            this.scoreImage.add(ImageResources.SCORE_2);
            this.scoreImage.add(ImageResources.SCORE_3);
            this.scoreImage.add(ImageResources.SCORE_4);
            this.scoreImage.add(ImageResources.SCORE_5);
            this.scoreImage.add(ImageResources.SCORE_6);
            this.scoreImage.add(ImageResources.SCORE_7);
            this.scoreImage.add(ImageResources.SCORE_8);
            this.scoreImage.add(ImageResources.SCORE_9);
        }
        if (this.columnString == null) {
            this.columnString = new ArrayList<String>();
            this.columnString.add(InformationViewLabels.SCORE_VIEW_FAIL_COUNT);
            this.columnString.add(InformationViewLabels.SCORE_VIEW_LEAK_SIZE);
            this.columnString.add(InformationViewLabels.SCORE_VIEW_WARNING_COUNT);
            this.columnString.add(InformationViewLabels.SCORE_VIEW_ELECTRIC_ENERGY);
        }
        if (this.columnValue == null) {
            this.columnValue = new ArrayList<Integer>();
            this.columnValue.add(0);
            this.columnValue.add(0);
            this.columnValue.add(0);
            this.columnValue.add(0);
        }
        this.setTitle(InformationViewLabels.SCORE_VIEW_SCORE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        contents.setLayout((Layout)new FormLayout());
        this.scoreBoard = new Canvas(contents, 0x40000000);
        this.scoreBoard.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int x = 0;
                int y = 0;
                Rectangle rect = ScoreView.this.scoreBoard.getBounds();
                e.gc.setBackground(ColorResources.BLACK);
                e.gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                e.gc.setForeground(ColorResources.TITLEBAR_TEXT_COLOR);
                e.gc.setFont(FontResources.SCORE_TITLE_FONT);
                Point textSize = e.gc.textExtent(InformationViewLabels.SCORE_VIEW_SCORE, 8);
                x = (rect.width - textSize.x) / 2;
                e.gc.drawString(InformationViewLabels.SCORE_VIEW_SCORE, x, y += 5);
                x = 1;
                e.gc.drawLine(1, y += 25, rect.width - 2, y);
                x = 12;
                e.gc.drawImage((Image)ScoreView.this.scoreImage.get(ScoreView.this.score / 100), 12, y += 18);
                e.gc.drawImage((Image)ScoreView.this.scoreImage.get(ScoreView.this.score / 10 % 10), x += 57, y);
                e.gc.drawImage((Image)ScoreView.this.scoreImage.get(ScoreView.this.score % 10), x += 57, y);
            }
        });
        this.scoreInfo = new Canvas(contents, 0x40000000);
        this.scoreInfo.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle colRect = new Rectangle(0, 0, 0, 30);
                int i = 0;
                while (i < 4) {
                    colRect.width = 110;
                    e.gc.setBackground(ColorResources.SNAPSHOT_VIEW_TABLE_TITLE_BG);
                    e.gc.fillRectangle(colRect);
                    e.gc.setForeground(ColorResources.SNAPSHOT_VIEW_TABLE_LINE);
                    e.gc.drawRectangle(colRect);
                    e.gc.setForeground(ColorResources.SNAPSHOT_VIEW_TABLE_TITLE_TEXT);
                    e.gc.setFont(FontResources.TABLE_CELL_FONT);
                    Point textSize = e.gc.textExtent((String)ScoreView.this.columnString.get(i), 8);
                    int x = (colRect.width - textSize.x) / 2;
                    int y = colRect.y + (colRect.height - textSize.y) / 2;
                    e.gc.drawString((String)ScoreView.this.columnString.get(i), x, y);
                    colRect.x += 110;
                    colRect.width = 84;
                    e.gc.setBackground(ColorResources.SNAPSHOT_VIEW_TABLE_CONTENTS_BG);
                    e.gc.fillRectangle(colRect);
                    e.gc.setForeground(ColorResources.SNAPSHOT_VIEW_TABLE_LINE);
                    e.gc.drawRectangle(colRect);
                    e.gc.setForeground(ColorResources.SNAPSHOT_VIEW_TABLE_CONTENTS_TEXT);
                    e.gc.setFont(FontResources.TABLE_CELL_FONT);
                    textSize = e.gc.textExtent(((Integer)ScoreView.this.columnValue.get(i)).toString(), 8);
                    x = colRect.x + (colRect.width - textSize.x) / 2;
                    y = colRect.y + (colRect.height - textSize.y) / 2;
                    e.gc.drawString(((Integer)ScoreView.this.columnValue.get(i)).toString(), x, y);
                    colRect.y += 30;
                    colRect.x = 0;
                    ++i;
                }
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.height = 132;
        this.scoreBoard.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.scoreBoard, 13);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.height = 122;
        this.scoreInfo.setLayoutData((Object)data);
    }

    public void updateView() {
        this.failCount = SummaryDataManager.getInstance().getFailedApiDataMaker().getFailedApiDataFromDB(Toolbar.INSTANCE.getSelectedPid(), null).size();
        this.warningSize = AnalyzerManager.getWarningChecker().getWarningData().size();
        this.columnValue.set(0, this.failCount);
        this.columnValue.set(1, this.leakSize);
        this.columnValue.set(2, this.warningSize);
        this.scoreInfo.redraw();
    }
}

