/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.tizen.dynamicanalyzer.ui.info.screenshot.EventMgr;
import org.tizen.dynamicanalyzer.ui.info.screenshot.IMsgProc;
import org.tizen.dynamicanalyzer.ui.info.screenshot.MsgProc_KeepAliveReq;
import org.tizen.dynamicanalyzer.ui.info.screenshot.MsgProc_MonitorNtf;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ecs.Ecs;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ecs.EcsIds;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.JsonUtil;

public class MsgMgr {
    private Map<EcsIds.Master_Type, IMsgProc> _msg_map = new HashMap<EcsIds.Master_Type, IMsgProc>();
    private String contents = null;
    private static MsgMgr _inst;

    MsgMgr() {
        this.AddMsgProc(EcsIds.Master_Type.MONITOR_NTF, new MsgProc_MonitorNtf());
        this.AddMsgProc(EcsIds.Master_Type.KEEPALIVE_REQ, new MsgProc_KeepAliveReq());
    }

    public static MsgMgr getInstance() {
        if (_inst == null) {
            _inst = new MsgMgr();
        }
        return _inst;
    }

    public void AddMsgProc(EcsIds.Master_Type type, IMsgProc proc) {
        this._msg_map.put(type, proc);
    }

    public IMsgProc FindMsgProc(EcsIds.Master_Type type) {
        IMsgProc proc = this._msg_map.get((Object)type);
        if (proc == null) {
            return null;
        }
        return proc;
    }

    void ProcBufMsg(Ecs.Master msg) {
        EcsIds.Master_Type subtype = msg.getType();
        IMsgProc proc = this.FindMsgProc(subtype);
        if (proc == null) {
            Logger.info((Object)("invalid message type - " + subtype.toString()));
            return;
        }
        if (msg.getType() == EcsIds.Master_Type.MONITOR_NTF) {
            String message = msg.getMonitorNtf().getCommand();
            if (this.contents == null) {
                this.contents = new String(message);
            } else {
                this.contents = this.contents.substring(0, this.contents.length() - 7);
                this.contents = String.valueOf(this.contents) + message;
            }
            if (!this.messageComplete(this.contents)) {
                return;
            }
            int lastBrace = this.contents.lastIndexOf("}");
            this.contents = this.contents.substring(0, lastBrace + 1);
            JSONObject obj = JsonUtil.decodeObject(this.contents);
            if (obj == null) {
                return;
            }
            EventMgr.getInstance().Invoke((String)obj.get((Object)"type"), obj);
            this.contents = null;
        } else {
            proc.Proc(msg);
        }
    }

    private boolean messageComplete(String msg) {
        int braceCount = 0;
        int i = 0;
        while (i < msg.length()) {
            char value = msg.charAt(i);
            if (value == '{') {
                ++braceCount;
            } else if (value == '}' && braceCount > 0) {
                --braceCount;
            }
            ++i;
        }
        return braceCount == 0;
    }
}

