/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data.util;

import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;

public class Query {
    public long startTime;
    public long endTime;
    public String pidString;
    public boolean onlyLeaks;

    public Query() {
        this.clear();
    }

    public Query(long startTime, long endTime) {
        this(startTime, endTime, false);
    }

    public Query(long startTime, long endTime, boolean onlyLeaks) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.onlyLeaks = onlyLeaks;
        this.pidString = Query.getTargetPIDString();
    }

    public void clear() {
        this.startTime = -1L;
        this.endTime = -1L;
        this.pidString = "";
        this.onlyLeaks = false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + (this.onlyLeaks ? 1231 : 1237);
        result = 31 * result + (this.pidString == null ? 0 : this.pidString.hashCode());
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.onlyLeaks != other.onlyLeaks) {
            return false;
        }
        if (this.pidString == null ? other.pidString != null : !this.pidString.equals(other.pidString)) {
            return false;
        }
        return this.startTime == other.startTime;
    }

    private static String getTargetPIDString() {
        StringBuilder pidliststring = new StringBuilder();
        pidliststring.append("(");
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidliststring.append(targetPID);
        } else {
            int[] nArray = Global.getProject().getProcessIDs();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int pid = nArray[n2];
                if (pidliststring.length() != 1) {
                    pidliststring.append(",");
                }
                pidliststring.append(pid);
                ++n2;
            }
        }
        pidliststring.append(")");
        return pidliststring.toString();
    }
}

