/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network;

import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.nl.NetworkPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkAPIType;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.DownloadContentfileManager;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class NetworkDetailView
extends DAViewComposite {
    private Composite contents = null;
    private Text detailText = null;
    private Label labelMessage = null;
    private static final String leftMargin = "  ";
    private static final String topMargin = String.valueOf(CommonConstants.NEW_LINE) + CommonConstants.NEW_LINE;

    private void init() {
        this.detailText.setText("");
    }

    public NetworkDetailView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(NetworkPageLabels.NETWORK_DETAILS_TITLE);
        Composite detailCom = this.getContentArea();
        detailCom.setBackground(ColorResources.VIEW_BG_COLOR);
        detailCom.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(100, 0);
        labelData.bottom = new FormAttachment(100, 0);
        detailCom.setLayoutData((Object)labelData);
        Composite contents = detailCom;
        contents.setBackground(ColorResources.VIEW_BG_COLOR);
        contents.setLayout((Layout)new FormLayout());
        this.detailText = new Text(contents, 2816);
        this.detailText.setBackground(ColorResources.VIEW_BG_COLOR);
        this.detailText.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.detailText.setFont(FontResources.DETAIL_INFO_FONT);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment((Control)this.labelMessage, 0);
        buttonData.left = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.detailText.setLayoutData((Object)buttonData);
        StringBuffer strDetailView = new StringBuffer(CommonConstants.NEW_LINE);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_ADDRESS);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_RECV_SIZE);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_SEND_SIZE);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_TOTAL_USE_TIME);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_API_COUNT);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_FAILED_API_COUNT);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_PAYLOAD_ASCII);
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_SEND_ACK_TIME);
        this.detailText.setText(strDetailView.toString());
    }

    public void updateView(DAViewData data) {
        if (!(data instanceof DASelectionData)) {
            return;
        }
        DASelectionData seldata = (DASelectionData)data;
        if (seldata.getData() instanceof GridItem[]) {
            GridItem[] tableData = (GridItem[])data.getData();
            DATableDataFormat tableFormat = (DATableDataFormat)tableData[0].getData();
            NetworkAPIType apiType = (NetworkAPIType)tableFormat.getLogData();
            this.updateData(apiType.getSeq());
        } else {
            this.updateData(0L);
        }
    }

    public void updateView() {
    }

    private void updateData(long seq) {
        List<NetworkAPIType> contentList = NetworkDataManager.getInstance().getSelectedTableAPIList();
        if (contentList == null) {
            return;
        }
        int sendSize = 0;
        int recvSize = 0;
        int apiCount = 0;
        int failedAPICount = 0;
        long recvTime = 0L;
        long sendTime = 0L;
        boolean isSendAPICall = false;
        String payload = "";
        int i = 0;
        while (i < contentList.size()) {
            NetworkAPIType apiType = contentList.get(i);
            if (this.isSendEndAPI(apiType)) {
                sendSize += apiType.getPacketMessageSize();
                if (this.isSelectedTableIndex(seq, apiType)) {
                    payload = apiType.getPacketMessage();
                    sendTime = apiType.getTime();
                    isSendAPICall = true;
                }
            } else if (this.isRecvEndAPI(apiType)) {
                recvSize += apiType.getPacketMessageSize();
                if (this.isSelectedTableIndex(seq, apiType)) {
                    payload = apiType.getPacketMessage();
                }
                if (isSendAPICall) {
                    isSendAPICall = false;
                    recvTime = apiType.getTime();
                }
            }
            if (apiType.getErrno() > 0L) {
                ++failedAPICount;
            }
            if (!this.isEndAPI(apiType)) {
                ++apiCount;
            }
            ++i;
        }
        StringBuffer strDetailView = new StringBuffer(topMargin);
        this.addDetailInfo(strDetailView, this.getAddress(contentList));
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_RECV_SIZE, Integer.toString(recvSize));
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_SEND_SIZE, Integer.toString(sendSize));
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_TOTAL_USE_TIME, this.getUsedTime(contentList));
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_API_COUNT, Integer.toString(apiCount));
        this.addDetailInfo(strDetailView, NetworkPageLabels.NETWORK_DETAILS_FAILED_API_COUNT, Integer.toString(failedAPICount));
        String ackTime = this.getSendAckTime(sendTime, recvTime);
        if (!ackTime.equals("")) {
            this.addDetailInfo(strDetailView, this.getSendAckTime(sendTime, recvTime));
        }
        if (!payload.equals("")) {
            strDetailView.append(this.getPacketMessage(DownloadContentfileManager.getFileContents(payload)));
        }
        this.detailText.setText(strDetailView.toString());
    }

    private String getUsedTime(List<NetworkAPIType> contentList) {
        long usedTime = contentList.get(contentList.size() - 1).getTime() - contentList.get(0).getTime();
        return Formatter.toTimeFormat(usedTime);
    }

    private String getSendAckTime(long sendTime, long recvTime) {
        String sendAckTime = "";
        if (sendTime <= 0L || recvTime <= 0L) {
            return sendAckTime;
        }
        long ackTime = recvTime - sendTime;
        String timeFormat = Formatter.toTimeFormat(ackTime);
        sendAckTime = timeFormat.replace("00:", "");
        return String.valueOf(NetworkPageLabels.NETWORK_DETAILS_SEND_ACK_TIME) + sendAckTime;
    }

    private boolean isSendEndAPI(NetworkAPIType apiType) {
        return apiType.getFdApiType() == 5 || apiType.getFdApiType() == 20;
    }

    private boolean isRecvEndAPI(NetworkAPIType apiType) {
        return apiType.getFdApiType() == 3 || apiType.getFdApiType() == 21;
    }

    private boolean isEndAPI(NetworkAPIType apiType) {
        return apiType.getFdApiType() == 3 || apiType.getFdApiType() == 5 || apiType.getFdApiType() == 10 || apiType.getFdApiType() == 12;
    }

    private boolean isSelectedTableIndex(long selectedSeq, NetworkAPIType apiType) {
        return selectedSeq == apiType.getSeq();
    }

    private String getAddress(List<NetworkAPIType> contentList) {
        String detailAddress = contentList.get(0).getDestinationAddress();
        detailAddress = detailAddress.replace(CommonConstants.NEW_LINE, ":");
        return String.valueOf(NetworkPageLabels.NETWORK_DETAILS_ADDRESS) + detailAddress;
    }

    private void addDetailInfo(StringBuffer strDetailView, String title, String detailInfo) {
        strDetailView.append(leftMargin + title + detailInfo + topMargin);
    }

    private void addDetailInfo(StringBuffer strDetailView, String info) {
        strDetailView.append(leftMargin + info + topMargin);
    }

    public String getPacketMessage(String packetMessage) {
        StringBuffer out = new StringBuffer(leftMargin);
        out.append(NetworkPageLabels.NETWORK_DETAILS_PAYLOAD_ASCII).append(CommonConstants.NEW_LINE).append(CommonConstants.NEW_LINE);
        out.append("    " + this.getAsciiPayload(packetMessage));
        out.append(topMargin);
        out.append(leftMargin);
        out.append(NetworkPageLabels.NETWORK_DETAILS_PAYLOAD_HEXCODE).append(CommonConstants.NEW_LINE);
        out.append(this.getHexPayload(packetMessage));
        return out.toString();
    }

    private String getAsciiPayload(String packetMessage) {
        StringBuffer strAscii = new StringBuffer();
        int nIndex = 0;
        while (nIndex < packetMessage.indexOf(0)) {
            strAscii.append(packetMessage.charAt(nIndex));
            ++nIndex;
        }
        return strAscii.toString();
    }

    private String getHexPayload(String packetMessage) {
        StringBuffer strHex = new StringBuffer();
        long hexAddress = 0L;
        int i = 0;
        while (i < packetMessage.length()) {
            if (this.isHexNewLine(i)) {
                strHex.append(CommonConstants.NEW_LINE).append(this.getHexAddress(++hexAddress)).append("\t");
            }
            strHex.append(String.format("%02X ", packetMessage.charAt(i)));
            ++i;
        }
        return strHex.toString();
    }

    private boolean isHexNewLine(int charIndex) {
        return charIndex % 8 == 0;
    }

    private String getHexAddress(long hexAddress) {
        String strHexCode = Long.toHexString(hexAddress).toUpperCase();
        String strhexAddress = "";
        if (strHexCode.length() == 1) {
            strhexAddress = String.valueOf(strhexAddress) + "00" + strHexCode + "0";
        } else if (strHexCode.length() == 2) {
            strhexAddress = String.valueOf(strhexAddress) + "0" + strHexCode + "0";
        } else if (strHexCode.length() == 3) {
            strhexAddress = String.valueOf(strhexAddress) + strHexCode + "0";
        }
        return strhexAddress;
    }

    public Control getControl() {
        return this.contents;
    }

    public void clear() {
        this.init();
    }
}

