/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateProgramType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateShaderType;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLStateProgramDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_PROGRAM";
    private static final String DBTYPE_TEXT = "VARCHAR(16384)";
    private static final int TYPE_PROGRAM = 1;
    private static final int TYPE_SHADER = 2;
    private static final int STATUS_NULL = -1;
    public static final String TYPE = "TYPE";
    public static final String ID = "PROGRAM_ID";
    public static final String SHADER_SRC = "SHADER_SRC";
    public static final String DELETE_STATUS = "DELETE_STATUS";
    public static final String LINK_STATUS = "LINK_STATUS";
    public static final String COMPILE_STATUS = "COMPILE_STATUS";
    public static final String FRAGMENT_ID = "FRAGMENT_ID";
    public static final String VERTEX_ID = "VERTEX_ID";
    public static final String CONTEXT_ID = "CONTEXT_ID";
    private static final String SELECT_QUERY = "select TYPE,PROGRAM_ID,SHADER_SRC,DELETE_STATUS,LINK_STATUS,COMPILE_STATUS,FRAGMENT_ID,VERTEX_ID,CONTEXT_ID from GL_PROGRAM";
    public static final int TABLE_TYPE_INDEX = 0;
    public static final int TABLE_ID_INDEX = 1;
    public static final int TABLE_SHADER_SRC_INDEX = 2;
    public static final int TABLE_DELETE_STATUS_INDEX = 3;
    public static final int TABLE_LINK_STATUS_INDEX = 4;
    public static final int TABLE_COMPILE_STATUS_INDEX = 5;
    public static final int TABLE_FRAGMENT_ID_INDEX = 6;
    public static final int TABLE_VERTEX_ID_INDEX = 7;
    public static final int TABLE_CONTEXT_NAME_INDEX = 8;

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLStateProgramDBTableManager() {
        this.addColumn(new DBColumn(TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(SHADER_SRC, "NOT NULL", DBTYPE_TEXT));
        this.addColumn(new DBColumn(DELETE_STATUS, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COMPILE_STATUS, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(LINK_STATUS, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(FRAGMENT_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(VERTEX_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(CONTEXT_ID, "NOT NULL", "BIGINT"));
    }

    /*
     * Exception decompiling
     */
    public void initProgramDataAtOpen() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initProgramData(ResultSet rs) {
        try {
            GLStateProgramType programType = new GLStateProgramType(rs.getInt(2));
            programType.setDeleteStatus(rs.getInt(4));
            programType.setLinkStatus(rs.getInt(5));
            programType.setFragmentShaderId(rs.getInt(7));
            programType.setVertexShaderId(rs.getInt(8));
            programType.setContextId(rs.getLong(9));
            GLDataManager.getInstance().getStateDataManager().getProgramMakeObject().addProgramList(programType);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
    }

    private void initSraderData(ResultSet rs) {
        try {
            GLStateShaderType shaderType = new GLStateShaderType(rs.getLong(9), rs.getInt(2));
            shaderType.setShaderSrc(rs.getString(3));
            shaderType.setDeleteStatus(rs.getInt(4));
            shaderType.setCompileStatus(rs.getInt(6));
            GLDataManager.getInstance().getStateDataManager().getProgramMakeObject().addShaderList(shaderType);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
    }

    public void insertProgramData() {
        ArrayList<List<Object>> insertObjectList = new ArrayList<List<Object>>();
        insertObjectList.addAll(this.makeInsertProgramData());
        insertObjectList.addAll(this.makeShaderData());
        this.insertData(insertObjectList);
    }

    private List<List<Object>> makeInsertProgramData() {
        List<GLStateProgramType> programList = GLDataManager.getInstance().getStateDataManager().getProgramMakeObject().getProgramList();
        ArrayList<List<Object>> returnObjectList = new ArrayList<List<Object>>();
        int i = 0;
        while (i < programList.size()) {
            GLStateProgramType programType = programList.get(i);
            ArrayList<Object> itemList = new ArrayList<Object>();
            itemList.add(1);
            itemList.add(programType.getId());
            itemList.add("");
            itemList.add(programType.getDeleteStatus());
            itemList.add(programType.getLinkStatus());
            itemList.add(-1);
            itemList.add(programType.getFragmentShaderId());
            itemList.add(programType.getVertexShaderId());
            itemList.add(programType.getContextId());
            returnObjectList.add(itemList);
            ++i;
        }
        return returnObjectList;
    }

    private List<List<Object>> makeShaderData() {
        ArrayList<List<Object>> returnObjectList = new ArrayList<List<Object>>();
        List<GLStateShaderType> shaderList = GLDataManager.getInstance().getStateDataManager().getProgramMakeObject().getShaderList();
        if (shaderList == null) {
            return returnObjectList;
        }
        int i = 0;
        while (i < shaderList.size()) {
            GLStateShaderType shaderType = shaderList.get(i);
            ArrayList<Object> itemList = new ArrayList<Object>();
            itemList.add(2);
            itemList.add(shaderType.getId());
            itemList.add(shaderType.getShaderSrc());
            itemList.add(shaderType.getDeleteStatus());
            itemList.add(-1);
            itemList.add(shaderType.getCompileStatus());
            itemList.add(-1);
            itemList.add(-1);
            itemList.add(shaderType.getContextId());
            returnObjectList.add(itemList);
            ++i;
        }
        return returnObjectList;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setString(3, (String)rowData.get(2));
                prep.setInt(4, (Integer)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setInt(6, (Integer)rowData.get(5));
                prep.setInt(7, (Integer)rowData.get(6));
                prep.setInt(8, (Integer)rowData.get(7));
                prep.setLong(9, (Long)rowData.get(8));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

