/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.page;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.util.Logger;

public class PageInfo {
    private final String pageName;
    private final String pageID;
    private final boolean isDefault;
    private final Constructor<?> pageCtor;
    private final HashSet<Class<?>> pageDataManagers;

    public PageInfo(Class<?> pageClass, String pageName, boolean isDefault) {
        this.pageName = pageName;
        this.pageID = pageClass.getName();
        Constructor<?> pageCtor = null;
        try {
            pageCtor = pageClass.getConstructor(Composite.class, Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            Logger.warning((String)"Can't find requested constructor for: ", (Object[])new Object[]{pageName});
        }
        this.pageCtor = pageCtor;
        this.pageDataManagers = new HashSet();
        this.isDefault = isDefault;
    }

    public PageInfo(Class<?> pageClass, String pageName) {
        this(pageClass, pageName, false);
    }

    public void addDataManager(Class<?> managerClass) {
        this.pageDataManagers.add(managerClass);
    }

    public Constructor<?> getPageCtor() {
        return this.pageCtor;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getPageID() {
        return this.pageID;
    }

    public HashSet<Class<?>> getDataManagers() {
        return this.pageDataManagers;
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

