/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.SummaryLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class WarningDetailView
extends DAViewComposite {
    protected boolean isRange = false;
    protected Canvas canvas = null;
    protected String warningMessage = "";
    protected final String titleText = SummaryLabels.FILE_DETAILS_TITLE;
    protected String selectionViewId = null;
    protected PaintListener detailPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Rectangle rect = WarningDetailView.this.canvas.getBounds();
            int width = rect.width - 20;
            e.gc.setBackground(ColorResources.VIEW_BG_COLOR);
            e.gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
            e.gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
            e.gc.setFont(FontResources.DETAIL_INFO_FONT);
            String text = WarningDetailView.this.warningMessage;
            Point titleSize = e.gc.textExtent(WarningDetailView.this.titleText, 8);
            int fontHeight = titleSize.y + 5;
            e.gc.drawText(WarningDetailView.this.titleText, 5, 0);
            int i = 1;
            while (text.length() > 0) {
                Point textSize = e.gc.textExtent(text, 8);
                String inputText = "";
                if (textSize.x > width) {
                    int strLen = width * text.length() / textSize.x;
                    inputText = String.valueOf(inputText) + text.substring(0, strLen - 1);
                    text = text.substring(strLen - 1, text.length());
                } else {
                    inputText = String.valueOf(inputText) + text;
                    text = "";
                }
                e.gc.drawText(inputText, 10, fontHeight * i);
                ++i;
            }
        }
    };

    public WarningDetailView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.VIEW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas(contents, 0x40000000);
        this.canvas.addPaintListener(this.detailPaintListener);
        this.selectionViewId = SummaryPage.warningListViewID;
    }

    public void updateView(DAViewData vdata) {
        DASelectionData data;
        if (vdata instanceof DASelectionData && (data = (DASelectionData)vdata).getViewID().equals(this.selectionViewId)) {
            GridItem[] items = (GridItem[])data.getData();
            if (items.length <= 0) {
                return;
            }
            GridItem item = items[0];
            DATableDataFormat tableData = (DATableDataFormat)item.getData();
            long seq = tableData.getLogData().getSeq();
            String msg = SummaryDataManager.getInstance().getWarningDataMaker().getFullWarningMessageByLogSeq(seq);
            this.warningMessage = msg == null ? "" : msg;
            this.canvas.redraw();
        }
    }

    public void clear() {
        this.warningMessage = "";
        this.canvas.redraw();
    }

    public void updateWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
        this.canvas.redraw();
    }
}

