/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DALimit;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.SyncData;
import org.tizen.dynamicanalyzer.swap.model.data.ThreadData;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadLoadDataMaker;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadSyncDataMaker;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadThreadDataMaker;
import org.tizen.dynamicanalyzer.ui.thread.db.SyncAPIDBTable;
import org.tizen.dynamicanalyzer.ui.thread.db.SyncDataDBTable;
import org.tizen.dynamicanalyzer.ui.thread.db.SyncEventDBTable;
import org.tizen.dynamicanalyzer.ui.thread.db.ThreadAPIDBTable;
import org.tizen.dynamicanalyzer.ui.thread.db.ThreadDataDBTable;
import org.tizen.dynamicanalyzer.ui.thread.db.ThreadEventDBTable;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncDataEvent;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadDataEvent;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadDataManager
extends PageDataManager {
    private static ThreadDataManager instance = new ThreadDataManager();
    public static final double THREAD_DATA_MEMORY_KB = 0.3;
    public static final double SYNC_DATA_MEMORY_KB = 0.3;
    public static final double CHART_TYPE_HEAP_MEMORY_KB = 23.0;
    public static final double MAX_THREAD_HEAP_MEMORY_KB = 10000.0;
    private ThreadDataDBTable threadDataTable = new ThreadDataDBTable();
    private ThreadEventDBTable threadEventTable = new ThreadEventDBTable();
    private ThreadAPIDBTable threadAPITable = new ThreadAPIDBTable();
    private SyncDataDBTable syncDataTable = new SyncDataDBTable();
    private SyncEventDBTable syncEventTable = new SyncEventDBTable();
    private SyncAPIDBTable syncAPITable = new SyncAPIDBTable();
    private DBInserter threadEventDBInserter = this.makeInserter(this.threadEventTable);
    private DBInserter threadAPIDBInserter = this.makeInserter(this.threadAPITable);
    private DBInserter syncDataDBInserter = this.makeInserter(this.syncDataTable);
    private DBInserter syncEventDBInserter = this.makeInserter(this.syncEventTable);
    private DBInserter syncAPIDBInserter = this.makeInserter(this.syncAPITable);
    private ThreadLoadDataMaker loadManager = new ThreadLoadDataMaker();
    private ThreadThreadDataMaker tManager = new ThreadThreadDataMaker();
    private ThreadSyncDataMaker sManager = new ThreadSyncDataMaker();

    private ThreadDataManager() {
    }

    public static ThreadDataManager getInstance() {
        return instance;
    }

    public ThreadThreadDataMaker getThreadDataMaker() {
        return this.tManager;
    }

    public ThreadSyncDataMaker getSyncDataMaker() {
        return this.sManager;
    }

    public void clear() {
        this.loadManager.clear();
        this.tManager.clear();
        this.sManager.clear();
    }

    @Override
    public void saveData(Map<String, String> dataMap) {
        this.inserthreadPageThreadData(this.tManager.getChartRowData(), false);
        this.sManager.insertNoBlockEndTimeSyncEvent();
        this.sManager.getNotInsertSyncEventList().clear();
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        this.selectThreadDataWhenOpen();
        this.selectSyncDataWhenOpen();
    }

    @Override
    protected void onThreadStop() {
        this.tManager.insertRemainingCallEvent();
    }

    private void checkHeapMemory() {
        double useHeapMemory = 0.0;
        useHeapMemory += (double)this.tManager.getChartRowData().size() * 0.3;
        useHeapMemory += (double)this.sManager.getChartRowData().size() * 0.3;
        int chartItemCount = this.tManager.getChartRowData().size() + this.sManager.getChartRowData().size();
        if (10000.0 < (useHeapMemory += 23.0 * (double)chartItemCount)) {
            DALimit.stopTraceAndOpenWarningDialog();
        }
    }

    private void selectThreadDataWhenOpen() {
        List<List<Object>> threadDatas = this.threadDataTable.getThreadDataFromDB();
        int size = threadDatas.size();
        int i = 0;
        while (i < size) {
            List<Object> rowData = threadDatas.get(i);
            int id = (Integer)rowData.get(ThreadDataDBTable.COLUMN.THREAD_DATA_ID.index);
            int pid = (Integer)rowData.get(ThreadDataDBTable.COLUMN.PID.index);
            int tid = (Integer)rowData.get(ThreadDataDBTable.COLUMN.TID.index);
            byte threadType = (Byte)rowData.get(ThreadDataDBTable.COLUMN.THREAD_TYPE.index);
            byte attrType = (Byte)rowData.get(ThreadDataDBTable.COLUMN.ATTRIBUTE_TYPE.index);
            String attributeType = ThreadThreadDataMaker.getAttrTypeByTypeInt(attrType);
            long startTime = (Long)rowData.get(ThreadDataDBTable.COLUMN.START_TIME.index);
            long endTime = (Long)rowData.get(ThreadDataDBTable.COLUMN.END_TIME.index);
            int functionID = (Integer)rowData.get(ThreadDataDBTable.COLUMN.API_ID.index);
            String className = (String)rowData.get(ThreadDataDBTable.COLUMN.CLASS_NAME.index);
            int createTID = (Integer)rowData.get(ThreadDataDBTable.COLUMN.CREATE_TID.index);
            int joinTID = (Integer)rowData.get(ThreadDataDBTable.COLUMN.JOIN_TID.index);
            ThreadPageThreadData threadData = new ThreadPageThreadData(id, pid, tid, threadType, attributeType, startTime, endTime, functionID, className, createTID, joinTID);
            this.tManager.setChartRowData(threadData);
            ++i;
        }
    }

    private void selectSyncDataWhenOpen() {
        List<List<Object>> syncDatas = this.syncDataTable.getSyncDataFromDB();
        int syncSize = syncDatas.size();
        int i = 0;
        while (i < syncSize) {
            ThreadPageSyncData syncData = this.makeSyncData(syncDatas.get(i));
            this.sManager.setChartRowData(syncData);
            ThreadPageSyncData parent = this.sManager.findParentData(syncData.getParentID());
            if (parent != null) {
                parent.pushSync(syncData);
            }
            ++i;
        }
    }

    private ThreadPageSyncData makeSyncData(List<Object> rowData) {
        ThreadPageSyncData syncData = null;
        int id = (Integer)rowData.get(SyncDataDBTable.COLUMN.SYNC_DATA_ID.index);
        int pid = (Integer)rowData.get(SyncDataDBTable.COLUMN.PID.index);
        int tid = (Integer)rowData.get(SyncDataDBTable.COLUMN.TID.index);
        byte syncType = (Byte)rowData.get(SyncDataDBTable.COLUMN.SYNC_TYPE.index);
        long syncValue = (Long)rowData.get(SyncDataDBTable.COLUMN.SYNC_VALUE.index);
        byte attrType = (Byte)rowData.get(SyncDataDBTable.COLUMN.ATTRIBUTE_TYPE.index);
        String attributeType = ThreadSyncDataMaker.getAttrTypeByTypeInt(attrType);
        byte syncDataType = (Byte)rowData.get(SyncDataDBTable.COLUMN.SYNC_DATA_TYPE.index);
        int parentID = (Integer)rowData.get(SyncDataDBTable.COLUMN.PARENT_ID.index);
        syncData = new ThreadPageSyncData(id, pid, tid, syncType, syncValue, attributeType, syncDataType, parentID);
        return syncData;
    }

    @Override
    protected void makeData(LogPackage pack) {
        List<LogData> syncInputs;
        List<LogData> threadInputs;
        List<LogData> loadInputs = this.getLogsFromLogPackage(pack, 5);
        if (loadInputs != null) {
            this.loadManager.makeLoadData(loadInputs);
        }
        if ((threadInputs = this.getLogsFromLogPackage(pack, 264)) != null) {
            this.tManager.makeThreadData(threadInputs);
            this.checkHeapMemory();
        }
        if ((syncInputs = this.getLogsFromLogPackage(pack, 272)) != null) {
            this.sManager.makeSyncData(syncInputs);
            this.checkHeapMemory();
        }
    }

    private List<LogData> getLogsFromLogPackage(LogPackage logPack, int logCenterConstants) {
        Logs logs = logPack.getLogs(logCenterConstants);
        if (logs == null || logs.getRawLogs().size() == 0) {
            return null;
        }
        List<LogData> ret = logs.getLogs();
        return ret;
    }

    public void insertSyncData(List<ThreadPageSyncData> insertSyncDataQueue, boolean byInserter) {
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        for (ThreadPageSyncData syncData : insertSyncDataQueue) {
            ArrayList<Number> insertRowData = new ArrayList<Number>();
            try {
                insertRowData.add(new Integer(syncData.getSyncDataID()));
                insertRowData.add(new Integer(syncData.getPid()));
                insertRowData.add(new Integer(syncData.getTid()));
                Integer type = new Integer(syncData.getType());
                byte syncType = type.byteValue();
                insertRowData.add(new Byte(syncType));
                insertRowData.add(new Long(syncData.getKey()));
                String attrTypeStr = syncData.getAttrType();
                int attrType = -1;
                attrType = attrTypeStr.equals(ThreadPageLabels.SYNC_ATTR_TYPE_NORMAL) ? 0 : (attrTypeStr.equals(ThreadPageLabels.SYNC_ATTR_TYPE_RECURSIVE) ? 1 : (attrTypeStr.equals(ThreadPageLabels.SYNC_ATTR_TYPE_ERRORCHECK) ? 2 : (attrTypeStr.equals(ThreadPageLabels.SYNC_ATTR_TYPE_DEFAULT) ? 3 : -1)));
                insertRowData.add(new Byte((byte)attrType));
                insertRowData.add(new Byte(syncData.getSyncDataType()));
                insertRowData.add(new Integer(syncData.getParentID()));
                insertData.add(insertRowData);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.exception((Throwable)e);
            }
        }
        if (!insertData.isEmpty()) {
            if (byInserter) {
                this.syncDataDBInserter.pushData(insertData);
            } else {
                this.syncDataTable.insertData(insertData);
            }
        }
    }

    public void insertSyncEventData(List<ThreadPageSyncDataEvent> syncEventQueue, boolean byInserter) {
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        for (ThreadPageSyncDataEvent syncEvent : syncEventQueue) {
            ArrayList<Object> insertRowData = new ArrayList<Object>();
            try {
                insertRowData.add(new Long(syncEvent.getContents().getSeq()));
                insertRowData.add(new Integer(syncEvent.getSyncDataID()));
                insertRowData.add(new Long(syncEvent.getTime()));
                Integer apiType = new Integer(syncEvent.getApiType());
                insertRowData.add(new Byte(apiType.byteValue()));
                insertRowData.add(new String(syncEvent.getTooltipContent()));
                insertRowData.add(new Long(syncEvent.getErrorNum()));
                insertRowData.add(new Long(syncEvent.getSyncVal()));
                insertRowData.add(new Long(syncEvent.getBlockEndTime()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.exception((Throwable)e);
            }
            insertData.add(insertRowData);
        }
        if (!insertData.isEmpty()) {
            if (byInserter) {
                this.syncEventDBInserter.pushData(insertData);
            } else {
                this.syncEventTable.insertData(insertData);
            }
        }
    }

    public void insertSyncAPIData(List<SyncData> insertSyncAPIList, boolean byInserter) {
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        for (SyncData syncAPI : insertSyncAPIList) {
            ArrayList<Object> insertRowData = new ArrayList<Object>();
            try {
                insertRowData.add(new Long(syncAPI.getSeq()));
                insertRowData.add(new Long(syncAPI.getTime()));
                insertRowData.add(new Integer(syncAPI.getApiId()));
                insertRowData.add(new Integer(syncAPI.getPid()));
                insertRowData.add(new Integer(syncAPI.getTid()));
                insertRowData.add(new String(syncAPI.getArgs()));
                insertRowData.add(new String(syncAPI.getReturn()));
                insertRowData.add(new Long(syncAPI.getErrno()));
                insertRowData.add(new Long(syncAPI.getSyncValue()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.exception((Throwable)e);
            }
            insertData.add(insertRowData);
        }
        if (!insertData.isEmpty()) {
            if (byInserter) {
                this.syncAPIDBInserter.pushData(insertData);
            } else {
                this.syncAPITable.insertData(insertData);
            }
        }
    }

    public void inserthreadPageThreadData(List<ThreadPageThreadData> remainedThreadData, boolean byInserter) {
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        for (ThreadPageThreadData threadPageData : remainedThreadData) {
            if (!(threadPageData instanceof ThreadPageThreadData)) continue;
            ArrayList<Object> insertRowData = new ArrayList<Object>();
            ThreadPageThreadData threadData = threadPageData;
            try {
                insertRowData.add(new Integer(threadData.getThreadDataID()));
                insertRowData.add(new Integer(threadData.getPid()));
                insertRowData.add(new Integer(threadData.getTid()));
                Integer type = new Integer(threadData.getType());
                byte threadType = type.byteValue();
                insertRowData.add(new Byte(threadType));
                String attrTypeStr = threadData.getAttrType();
                byte attrType = -1;
                attrType = attrTypeStr.equals(ThreadPageLabels.THREAD_ATTR_TYPE_JOINABLE) ? (byte)0 : (attrTypeStr.equals(ThreadPageLabels.THREAD_ATTR_TYPE_DETACHED) ? (byte)1 : -1);
                insertRowData.add(new Byte(attrType));
                insertRowData.add(new Long(threadData.getStartTime()));
                insertRowData.add(new Long(threadData.getEndTime()));
                insertRowData.add(new Integer(threadData.getThreadFuncID()));
                insertRowData.add(new String(threadData.getThreadClassName()));
                insertRowData.add(new Integer(threadData.getCreateTID()));
                insertRowData.add(new Integer(threadData.getJoinTID()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.exception((Throwable)e);
            }
            insertData.add(insertRowData);
        }
        if (!insertData.isEmpty()) {
            if (byInserter) {
                this.threadDataTable.insertData(insertData);
            } else {
                this.threadDataTable.insertData(insertData);
            }
        }
    }

    public void insertThreadEventData(List<ThreadPageThreadDataEvent> ThreadEventList, boolean byInserter) {
        ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
        for (ThreadPageThreadDataEvent threadEvent : ThreadEventList) {
            ArrayList<Object> insertRowData = new ArrayList<Object>();
            try {
                insertRowData.add(new Integer(threadEvent.getThreadDataID()));
                insertRowData.add(new Long(threadEvent.getTime()));
                insertRowData.add(new Integer(threadEvent.getTid()));
                Integer apiType = new Integer(threadEvent.getApiType());
                insertRowData.add(new Byte(apiType.byteValue()));
                insertRowData.add(new String(threadEvent.getTooltipContent()));
                insertRowData.add(new Long(threadEvent.getErrorNum()));
                Integer eventType = new Integer(threadEvent.getEventType());
                insertRowData.add(new Byte(eventType.byteValue()));
                insertRowData.add(new Integer(threadEvent.getThreadType()));
                insertRowData.add(new Integer(threadEvent.getCallerTid()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.exception((Throwable)e);
            }
            insertData.add(insertRowData);
        }
        if (!insertData.isEmpty()) {
            if (byInserter) {
                this.threadEventDBInserter.pushData(insertData);
            } else {
                this.threadEventTable.insertData(insertData);
            }
        }
    }

    public void insertThreadAPIData(List<ThreadPageThreadDataEvent> insertThreadEventList, boolean byInserter) {
        ArrayList<List<Object>> apiData = new ArrayList<List<Object>>();
        for (ThreadPageThreadDataEvent threadEvent : insertThreadEventList) {
            if (threadEvent.getEventType() != 0) continue;
            ArrayList<Object> apiRowData = new ArrayList<Object>();
            ThreadData tData = (ThreadData)threadEvent.getContents();
            try {
                apiRowData.add(new Long(tData.getSeq()));
                apiRowData.add(new Integer(threadEvent.getThreadDataID()));
                apiRowData.add(new Long(tData.getTime()));
                apiRowData.add(new Integer(tData.getApiId()));
                apiRowData.add(new Integer(tData.getPid()));
                apiRowData.add(new Integer(tData.getTid()));
                apiRowData.add(new String(tData.getArgs()));
                apiRowData.add(new String(tData.getReturn()));
                apiRowData.add(new Long(tData.getErrno()));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Logger.exception((Throwable)e);
            }
            apiData.add(apiRowData);
        }
        if (!apiData.isEmpty()) {
            if (byInserter) {
                this.threadAPIDBInserter.pushData(apiData);
            } else {
                this.threadAPITable.insertData(apiData);
            }
        }
    }
}

