/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadDataDBTable
extends DBTable {
    public static final String TABLENAME = "THREAD_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public ThreadDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.THREAD_DATA_ID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.THREAD_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.ATTRIBUTE_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.START_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.END_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.API_ID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CLASS_NAME.name, "", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.CREATE_TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.JOIN_TID.name, "NOT NULL", "INTEGER"));
    }

    public List<List<Object>> getThreadDataFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.THREAD_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.THREAD_DATA_ID.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setByte(COLUMN.THREAD_TYPE.index + 1, (Byte)rowData.get(COLUMN.THREAD_TYPE.index));
                prep.setByte(COLUMN.ATTRIBUTE_TYPE.index + 1, (Byte)rowData.get(COLUMN.ATTRIBUTE_TYPE.index));
                prep.setLong(COLUMN.START_TIME.index + 1, (Long)rowData.get(COLUMN.START_TIME.index));
                prep.setLong(COLUMN.END_TIME.index + 1, (Long)rowData.get(COLUMN.END_TIME.index));
                prep.setInt(COLUMN.API_ID.index + 1, (Integer)rowData.get(COLUMN.API_ID.index));
                String classNameStr = this.clipString((String)rowData.get(COLUMN.CLASS_NAME.index), 1024, rowData.get(COLUMN.THREAD_DATA_ID.index).toString());
                prep.setString(COLUMN.CLASS_NAME.index + 1, classNameStr);
                prep.setInt(COLUMN.CREATE_TID.index + 1, (Integer)rowData.get(COLUMN.CREATE_TID.index));
                prep.setInt(COLUMN.JOIN_TID.index + 1, (Integer)rowData.get(COLUMN.JOIN_TID.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(COLUMN.THREAD_DATA_ID.index + 1));
            row.add(rs.getInt(COLUMN.PID.index + 1));
            row.add(rs.getInt(COLUMN.TID.index + 1));
            row.add(rs.getByte(COLUMN.THREAD_TYPE.index + 1));
            row.add(rs.getByte(COLUMN.ATTRIBUTE_TYPE.index + 1));
            row.add(rs.getLong(COLUMN.START_TIME.index + 1));
            row.add(rs.getLong(COLUMN.END_TIME.index + 1));
            row.add(rs.getInt(COLUMN.API_ID.index + 1));
            row.add(rs.getString(COLUMN.CLASS_NAME.index + 1));
            row.add(rs.getInt(COLUMN.CREATE_TID.index + 1));
            row.add(rs.getInt(COLUMN.JOIN_TID.index + 1));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        THREAD_DATA_ID(0, "THREAD_DATA_ID"),
        PID(1, "PID"),
        TID(2, "TID"),
        THREAD_TYPE(3, "THREAD_TYPE"),
        ATTRIBUTE_TYPE(4, "ATTRIBUTE_TYPE"),
        START_TIME(5, "START_TIME"),
        END_TIME(6, "END_TIME"),
        API_ID(7, "API_ID"),
        CLASS_NAME(8, "CLASS_NAME"),
        CREATE_TID(9, "CREATE_TID"),
        JOIN_TID(10, "JOIN_TID");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

