/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.List;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.DiskIOChartRenderer;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class DiskIOChart
extends TimelineChart {
    private DAChartSeries readOpCountSeries;
    private DAChartSeries writeOpCountSeries;
    private DAChartSeries readByteSizeSeries;
    private DAChartSeries writeByteSizeSeries;
    private long maxOpCount = 10L;
    private long maxReadWriteSize = 100L;

    public DiskIOChart(String pageID) {
        super(pageID);
        this.chartType = -110;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.DISK_IO_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.DISK_IO_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_DISKIO_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_DISKIO_SMALL_NOR;
        this.readOpCountSeries = new DAChartSeries(TimelineChartLabels.DISK_IO_CHART_SERIES_READ_OP_COUNT, 2, ColorResources.CHART_SERIES_RED);
        this.writeOpCountSeries = new DAChartSeries(TimelineChartLabels.DISK_IO_CHART_SERIES_WRITE_OP_COUNT, 2, ColorResources.CHART_SERIES_PURPLE);
        this.readByteSizeSeries = new DAChartSeries(TimelineChartLabels.DISK_IO_CHART_SERIES_READ_BYTE_SIZE, 2, ColorResources.CHART_SERIES_ORANGE);
        this.writeByteSizeSeries = new DAChartSeries(TimelineChartLabels.DISK_IO_CHART_SERIES_WRITE_BYTE_SIZE, 2, ColorResources.CHART_SERIES_PINK);
        this.readOpCountSeries.setFont(FontResources.TIMELINE_UIEVENT_FONT);
        this.writeOpCountSeries.setFont(FontResources.TIMELINE_UIEVENT_FONT);
        this.readByteSizeSeries.setFont(FontResources.TIMELINE_UIEVENT_FONT);
        this.writeByteSizeSeries.setFont(FontResources.TIMELINE_UIEVENT_FONT);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard) {
        DAChartBoardItem item = super.createBoardItem(chartBoard);
        this.chart.addSeries(this.readOpCountSeries);
        this.chart.addSeries(this.writeOpCountSeries);
        this.chart.addSeries(this.readByteSizeSeries);
        this.chart.addSeries(this.writeByteSizeSeries);
        this.chart.setChartRenderer((DAChartRenderer)new DiskIOChartRenderer());
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        this.readOpCountSeries.setEndY(0.0);
        this.writeOpCountSeries.setEndY(0.0);
        this.readByteSizeSeries.setEndY(0.0);
        this.writeByteSizeSeries.setEndY(0.0);
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.readOpCountSeries.clear();
        this.writeOpCountSeries.clear();
        this.readByteSizeSeries.clear();
        this.writeByteSizeSeries.clear();
        List data = (List)dataList.get(0);
        int i = 0;
        while (i < data.size()) {
            List row = (List)data.get(i);
            double time = (double)((Long)row.get(SystemDataDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
            long readCount = (Long)row.get(SystemDataDBTable.COLUMN.DISK_IO_READ_OP_COUNT.ordinal());
            long writeCount = (Long)row.get(SystemDataDBTable.COLUMN.DISK_IO_WRITE_OP_COUNT.ordinal());
            long readByteSize = (Long)row.get(SystemDataDBTable.COLUMN.DISK_IO_READ_BYTE_SIZE.ordinal());
            long writeByteSize = (Long)row.get(SystemDataDBTable.COLUMN.DISK_IO_WRITE_BYTE_SIZE.ordinal());
            this.readOpCountSeries.addSeriesItem(new DAChartSeriesItem(time, (double)readCount, String.valueOf(readCount)));
            this.writeOpCountSeries.addSeriesItem(new DAChartSeriesItem(time, (double)writeCount, String.valueOf(writeCount)));
            this.readByteSizeSeries.addSeriesItem(new DAChartSeriesItem(time, (double)readByteSize, Formatter.toByteFormat(readByteSize)));
            this.writeByteSizeSeries.addSeriesItem(new DAChartSeriesItem(time, (double)writeByteSize, Formatter.toByteFormat(writeByteSize)));
            if (this.maxOpCount < readCount) {
                this.maxOpCount = (int)((double)readCount * 1.1);
            }
            if (this.maxOpCount < writeCount) {
                this.maxOpCount = (int)((double)writeCount * 1.1);
            }
            if (this.maxReadWriteSize < readByteSize) {
                this.maxReadWriteSize = (int)((double)readByteSize * 1.1);
            }
            if (this.maxReadWriteSize < writeByteSize) {
                this.maxReadWriteSize = (int)((double)writeByteSize * 1.1);
            }
            ++i;
        }
        this.readOpCountSeries.setEndY((double)this.maxOpCount);
        this.writeOpCountSeries.setEndY((double)this.maxOpCount);
        this.readByteSizeSeries.setEndY((double)this.maxReadWriteSize);
        this.writeByteSizeSeries.setEndY((double)this.maxReadWriteSize);
    }
}

