/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.nl.PreferencesDialogLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomExtendButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class PreferencesDialog
extends DAMessageBox {
    private static boolean opened = false;
    private static boolean screenshotFeatureEnabled = false;
    private static boolean leakSanitizerEnabled = false;
    private ScrolledComposite scrolledComp = null;
    private Composite buttonContentsComp = null;
    private static final int DIALOG_HEIGHT = 540;
    private static final int DIALOG_WIDTH = 450;
    private static final int LABLE_LEFT_MARGIN = 35;
    private static final int LABLE_WIDTH = 150;
    private static final int LABLE_INTERVAL = 21;
    private static final int CONTROL_HEIGHT = 24;
    private static final int CONTROL_WIDTH = 76;
    private static final int GRID_SPACING = 5;
    private DACustomToggleButton sourceviewtoggle = null;
    private DACustomToggleButton periodicallyToggle = null;
    private DACustomToggleButton onSceneTransitionToggle = null;
    private DACustomToggleButton leakSanitizerToggle = null;
    private DACustomCombo systemRateCombo = null;
    private DACustomCombo functionRateCombo = null;
    private DACustomCombo screenshotRateCombo = null;
    private Button okButton;
    private Composite memoryProfilingView = null;
    private List<Composite> configs = new ArrayList<Composite>();
    private EnumMap<FlatFeature, Composite> featureConfigs = new EnumMap(FlatFeature.class);
    private FlatFeature selectedFeature = null;

    public PreferencesDialog(Shell parentShell) {
        super(parentShell);
    }

    public Object open(FlatFeature feature) {
        this.selectedFeature = feature;
        return this.open();
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 450) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 540) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(450, 540);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(PreferencesDialogLabels.TITLE);
        this.shell.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        Composite marginTop = new Composite((Composite)this.shell, 0);
        this.scrolledComp = new ScrolledComposite((Composite)this.shell, 512);
        Composite marginMiddle = new Composite((Composite)this.shell, 0);
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        marginTop.setLayout((Layout)new FormLayout());
        FormData marginCompData = new FormData();
        marginCompData.top = new FormAttachment(0, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(0, 1);
        marginTop.setLayoutData((Object)marginCompData);
        marginTop.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        this.scrolledComp.setLayout((Layout)new FormLayout());
        FormData scrollCompData = new FormData();
        scrollCompData.top = new FormAttachment((Control)marginTop, 0);
        scrollCompData.left = new FormAttachment(0, 0);
        scrollCompData.right = new FormAttachment(100, 0);
        scrollCompData.bottom = new FormAttachment(100, -61);
        this.scrolledComp.setLayoutData((Object)scrollCompData);
        this.scrolledComp.setExpandVertical(true);
        this.scrolledComp.setExpandHorizontal(true);
        this.scrolledComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.scrolledComp.getVerticalBar().setIncrement(12);
        this.scrolledComp.setFocus();
        marginMiddle.setLayout((Layout)new FormLayout());
        marginCompData = new FormData();
        marginCompData.top = new FormAttachment((Control)this.scrolledComp, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(100, -60);
        marginMiddle.setLayoutData((Object)marginCompData);
        marginMiddle.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        this.buttonContentsComp.setLayout((Layout)new FormLayout());
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)marginMiddle, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.buttonContentsComp.setLayoutData((Object)compData);
        this.buttonContentsComp.setBackground(ColorResources.WHITE);
        screenshotFeatureEnabled = SettingDataManager.INSTANCE.isFlatFeatureSelected(FlatFeature.SCREENSHOT);
        boolean bl = leakSanitizerEnabled = SettingDataManager.INSTANCE.isFlatFeatureSelected(FlatFeature.MEMORY_ALLOC) && !SettingDataManager.INSTANCE.isFlatFeatureSelected(FlatFeature.THREAD_ANALYSIS);
        if (leakSanitizerEnabled) {
            DeviceInfo device = Global.getCurrentDeviceInfo();
            boolean leakSanitizerSupported = false;
            if (device != null) {
                Protocol usedProtocol = Protocol.getVersion(device.getCommunicator().getProtocolVersion());
                leakSanitizerSupported = usedProtocol.getVersionNum() >= Protocol.VERSION_42.getVersionNum();
            }
            leakSanitizerEnabled = leakSanitizerSupported;
        }
        this.drawPreferenceCom();
        this.initComboBoxes();
        this.drawButtonCom();
        this.setOptions(false);
        if (DAState.isRunning()) {
            this.disableConfiguration();
        }
        if (this.selectedFeature != null) {
            Composite selectedConfig = this.featureConfigs.get((Object)this.selectedFeature);
            for (Composite config : this.configs) {
                if (config == selectedConfig) continue;
                config.dispose();
            }
            this.scrolledComp.layout(true);
        }
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        this.shell.open();
        return true;
    }

    private void drawPreferenceCom() {
        RowLayout parentLayout = new RowLayout(512);
        parentLayout.spacing = 10;
        parentLayout.marginWidth = 10;
        parentLayout.marginHeight = 10;
        GridLayout childLayout = new GridLayout();
        childLayout.numColumns = 4;
        childLayout.verticalSpacing = 10;
        childLayout.horizontalSpacing = 5;
        int generalviewHeight = 114;
        int screenshotViewHeight = 69;
        int memoryProfilingViewHeight = 34;
        Composite baseCom = new Composite((Composite)this.scrolledComp, 0);
        baseCom.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        baseCom.setLayout((Layout)parentLayout);
        Composite generalBaseView = new Composite(baseCom, 0);
        generalBaseView.setLayoutData((Object)new RowData());
        generalBaseView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        generalBaseView.setLayout((Layout)parentLayout);
        this.configs.add(generalBaseView);
        DACustomExtendButton generalExtend = this.createFoldingButton(generalBaseView, PreferencesDialogLabels.GENERAL);
        Composite generalView = new Composite(generalBaseView, 0);
        generalView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        generalView.setLayout((Layout)childLayout);
        generalView.setLayoutData((Object)new RowData(-1, generalviewHeight));
        generalExtend.addClickListener(this.createExpandListener(generalView));
        this.createLabel(generalView, PreferencesDialogLabels.SOURCE_VIEW, 2);
        this.sourceviewtoggle = this.createToggleButton(generalView);
        this.createLabel(generalView, PreferencesDialogLabels.SYSTEM_SAMPLIING_RATE, 2);
        this.systemRateCombo = this.makeDACustomCombo(generalView, "ms");
        this.createLabel(generalView, PreferencesDialogLabels.FUNCION_SAMPLIING_RATE, 2);
        this.functionRateCombo = this.makeDACustomCombo(generalView, "ms");
        Composite screenshotBaseView = new Composite(baseCom, 0);
        screenshotBaseView.setLayoutData((Object)new RowData());
        screenshotBaseView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        screenshotBaseView.setLayout((Layout)parentLayout);
        this.configs.add(screenshotBaseView);
        this.featureConfigs.put(FlatFeature.SCREENSHOT, screenshotBaseView);
        DACustomExtendButton screenshotExtend = this.createFoldingButton(screenshotBaseView, PreferencesDialogLabels.SCREENSHOT);
        Composite screenshotView = new Composite(screenshotBaseView, 0);
        screenshotView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        screenshotView.setLayoutData((Object)new RowData(-1, screenshotViewHeight));
        screenshotView.setLayout((Layout)childLayout);
        screenshotExtend.addClickListener(this.createExpandListener(screenshotView));
        this.createLabel(screenshotView, PreferencesDialogLabels.PERIODICALLY, 1);
        this.periodicallyToggle = this.createToggleButton(screenshotView);
        this.screenshotRateCombo = this.makeDACustomCombo(screenshotView, "s");
        this.screenshotRateCombo.setEnabled(false);
        this.periodicallyToggle.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                PreferencesDialog.this.screenshotRateCombo.setEnabled(PreferencesDialog.this.periodicallyToggle.isToggled());
            }
        });
        this.createLabel(screenshotView, PreferencesDialogLabels.ON_SCENE_TRANSITION, 2);
        this.onSceneTransitionToggle = this.createToggleButton(screenshotView);
        Composite memoryProfilingBaseView = new Composite(baseCom, 0);
        memoryProfilingBaseView.setLayoutData((Object)new RowData());
        memoryProfilingBaseView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        memoryProfilingBaseView.setLayout((Layout)parentLayout);
        this.configs.add(memoryProfilingBaseView);
        this.featureConfigs.put(FlatFeature.MEMORY_ALLOC, memoryProfilingBaseView);
        DACustomExtendButton memoryProfilingExtend = this.createFoldingButton(memoryProfilingBaseView, PreferencesDialogLabels.HEAP_ALLOCATION);
        this.memoryProfilingView = new Composite(memoryProfilingBaseView, 0);
        this.memoryProfilingView.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.memoryProfilingView.setLayoutData((Object)new RowData(-1, memoryProfilingViewHeight));
        this.memoryProfilingView.setLayout((Layout)childLayout);
        memoryProfilingExtend.addClickListener(this.createExpandListener(this.memoryProfilingView));
        this.createLabel(this.memoryProfilingView, PreferencesDialogLabels.LEAK_SANITIZER, 2);
        this.leakSanitizerToggle = this.createToggleButton(this.memoryProfilingView);
        this.leakSanitizerToggle.setToolTipText(PreferencesDialogLabels.LEAK_SANITIZER_TOOLTIP);
        this.scrolledComp.setContent((Control)baseCom);
        this.scrolledComp.setMinSize(baseCom.computeSize(-1, -1));
    }

    private DACustomButtonClickEventListener createExpandListener(final Composite view) {
        return new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                RowData data = (RowData)view.getLayoutData();
                data.exclude = !data.exclude;
                view.setVisible(!data.exclude);
                Composite baseComp = view.getParent().getParent();
                PreferencesDialog.this.scrolledComp.setMinSize(baseComp.computeSize(-1, -1));
                PreferencesDialog.this.scrolledComp.layout(true, true);
            }
        };
    }

    private void drawButtonCom() {
        this.okButton = new Button(this.buttonContentsComp, 0);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment(100, -15);
        buttonData.width = 100;
        buttonData.height = 30;
        this.okButton.setLayoutData((Object)buttonData);
        this.okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.applyPreferenceData();
                if (DAState.isStartable()) {
                    CommonAction.configure();
                }
                SettingDataManager.INSTANCE.applySettingData();
                PreferencesDialog.this.shell.dispose();
            }
        });
        Button cancelButton = new Button(this.buttonContentsComp, 0);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment((Control)this.okButton, -8);
        buttonData.width = 100;
        buttonData.height = 30;
        cancelButton.setLayoutData((Object)buttonData);
        cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        cancelButton.setText(WidgetLabels.CANCEL);
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.shell.dispose();
            }
        });
        Button resetToDefaultButton = new Button(this.buttonContentsComp, 0);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment((Control)cancelButton, -8);
        buttonData.width = 115;
        buttonData.height = 30;
        resetToDefaultButton.setLayoutData((Object)buttonData);
        resetToDefaultButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        resetToDefaultButton.setText(PreferencesDialogLabels.RESET_TO_DEFAULT);
        resetToDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PreferencesDialog.this.setOptions(true);
                PreferencesDialog.this.scrolledComp.setFocus();
            }
        });
    }

    private void setOptions(boolean reset) {
        if (this.selectedFeature == null) {
            this.setGeneralOptions(reset);
            this.setScreenshotOptions(reset);
            this.setHeapAllocationOptions(reset);
            return;
        }
        switch (this.selectedFeature) {
            case SCREENSHOT: {
                this.setScreenshotOptions(reset);
                break;
            }
            case MEMORY_ALLOC: {
                this.setHeapAllocationOptions(reset);
                break;
            }
        }
    }

    private void setGeneralOptions(boolean reset) {
        int value = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.SOURCE_VIEW, reset);
        this.sourceviewtoggle.setToggled(value == 1);
        MenuBar.getInstance().setSourceView(value == 1);
        value = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.SYSTEM_SAMPLING_RATE, reset);
        this.systemRateCombo.setText(String.valueOf(value));
        value = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.FUNCTION_SAMPLING_RATE, reset);
        this.functionRateCombo.setText(String.valueOf(value));
    }

    private void setScreenshotOptions(boolean reset) {
        if (screenshotFeatureEnabled) {
            int value = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.SCREENSHOT_PERIODICALLY, reset);
            boolean enabled = value != 0;
            this.periodicallyToggle.setToggled(enabled);
            this.periodicallyToggle.setButtonEnabled(true);
            this.screenshotRateCombo.setEnabled(enabled);
            if (enabled) {
                this.screenshotRateCombo.setText(String.valueOf(value));
            }
            enabled = SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION, reset);
            this.onSceneTransitionToggle.setToggled(enabled);
            this.onSceneTransitionToggle.setButtonEnabled(true);
        } else {
            this.periodicallyToggle.setToggled(false);
            this.periodicallyToggle.setButtonEnabled(false);
            this.screenshotRateCombo.setEnabled(false);
            this.onSceneTransitionToggle.setToggled(false);
            this.onSceneTransitionToggle.setButtonEnabled(false);
        }
    }

    private void setHeapAllocationOptions(boolean reset) {
        if (leakSanitizerEnabled) {
            boolean enabled = SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER, reset);
            this.leakSanitizerToggle.setToggled(enabled);
            this.leakSanitizerToggle.setButtonEnabled(true);
        } else {
            this.leakSanitizerToggle.setToggled(false);
            this.leakSanitizerToggle.setButtonEnabled(false);
        }
    }

    private DACustomExtendButton createFoldingButton(Composite parent, String text) {
        DACustomExtendButton foldingbutton = new DACustomExtendButton(parent, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_UP_NORL, ImageResources.DROP_ARROW_UP_NORL);
        foldingbutton.setButtonImagePoint(new Point(0, 5));
        foldingbutton.setText(text);
        foldingbutton.setFontPoint(new Point(19, 0));
        foldingbutton.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        foldingbutton.setButtonFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        RowData rowData = new RowData(200, 24);
        foldingbutton.setLayoutData((Object)rowData);
        return foldingbutton;
    }

    private DACustomToggleButton createToggleButton(Composite parent) {
        DACustomToggleButton toggle = new DACustomToggleButton(parent, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF, ImageResources.TOGGLE_OFF_DIM, ImageResources.TOGGLE_ON, ImageResources.TOGGLE_ON, ImageResources.TOGGLE_ON_DIM, ImageResources.TOGGLE_ON);
        Point imagePoint = new Point(0, 0);
        toggle.setButtonImagePoint(imagePoint);
        GridData gridData = new GridData(16384, 1024, false, false);
        gridData.widthHint = 76;
        gridData.heightHint = 24;
        toggle.setLayoutData((Object)gridData);
        return toggle;
    }

    private Label createLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        label.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        label.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        label.setText(text);
        GridData gridData = new GridData(16384, 0x1000000, true, false, horizontalSpan, 1);
        gridData.horizontalIndent = 35;
        gridData.minimumWidth = 150 + 81 * (horizontalSpan - 1);
        gridData.minimumHeight = 24;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void applyPreferenceData() {
        if (this.selectedFeature == null) {
            this.saveGeneralOptions();
            this.saveScreenshotOptions();
            this.saveHeapAllocationOptions();
            return;
        }
        switch (this.selectedFeature) {
            case SCREENSHOT: {
                this.saveScreenshotOptions();
                break;
            }
            case MEMORY_ALLOC: {
                this.saveHeapAllocationOptions();
                break;
            }
        }
    }

    private void saveGeneralOptions() {
        int rate;
        boolean sourceViewEnabled = this.sourceviewtoggle.isToggled();
        MenuBar.getInstance().setSourceView(sourceViewEnabled);
        SettingDataManager.INSTANCE.setPreferenceValue(FlatPreferences.SOURCE_VIEW, sourceViewEnabled ? 1 : 0);
        String ratestring = this.systemRateCombo.getText();
        try {
            rate = Integer.parseInt(ratestring);
            SettingDataManager.INSTANCE.setPreferenceValue(FlatPreferences.SYSTEM_SAMPLING_RATE, rate);
        }
        catch (NumberFormatException ex) {
            Logger.warning((Object)("Failed to save system sampling rate: " + ex.getLocalizedMessage()));
        }
        ratestring = this.functionRateCombo.getText();
        try {
            rate = Integer.parseInt(ratestring);
            SettingDataManager.INSTANCE.setPreferenceValue(FlatPreferences.FUNCTION_SAMPLING_RATE, rate);
        }
        catch (NumberFormatException ex) {
            Logger.warning((Object)("Failed to save function sampling rate: " + ex.getLocalizedMessage()));
        }
    }

    private void saveScreenshotOptions() {
        if (this.periodicallyToggle.isToggled()) {
            String ratestring = this.screenshotRateCombo.getText();
            try {
                int rate = Integer.parseInt(ratestring);
                SettingDataManager.INSTANCE.setPreferenceValue(FlatPreferences.SCREENSHOT_PERIODICALLY, rate);
            }
            catch (NumberFormatException ex) {
                Logger.warning((Object)("Failed to save screenshots rate: " + ex.getLocalizedMessage()));
            }
        } else {
            SettingDataManager.INSTANCE.setPreferenceValue(FlatPreferences.SCREENSHOT_PERIODICALLY, 0);
        }
        SettingDataManager.INSTANCE.setPreferenceSelected(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION, this.onSceneTransitionToggle.isToggled());
    }

    private void saveHeapAllocationOptions() {
        SettingDataManager.INSTANCE.setPreferenceSelected(FlatPreferences.LEAK_SANITIZER, this.leakSanitizerToggle.isToggled());
        MemoryPage memoryPage = (MemoryPage)AnalyzerUtil.getTabPage(MemoryPage.pageID);
        if (memoryPage != null) {
            memoryPage.showLeaksView(this.leakSanitizerToggle.isToggled());
            memoryPage.updateView();
        }
    }

    private DACustomCombo makeDACustomCombo(Composite parent, String unit) {
        DACustomCombo combo = new DACustomCombo(parent, 0);
        combo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        combo.setOutlineColors(ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130);
        combo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        combo.setComboImagePoint(new Point(61, 9));
        combo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        combo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        combo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        combo.setFontPoint(new Point(5, 5));
        combo.setEnabled(true);
        combo.setComboFont(FontResources.COMBO);
        combo.setItemFont(FontResources.DROPDOWN);
        combo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.widthHint = 76;
        data.heightHint = 24;
        combo.setLayoutData((Object)data);
        Label unitlabel = new Label(parent, 16384);
        data = new GridData(16384, 0x1000000, false, false);
        data.minimumWidth = 20;
        data.minimumHeight = 24;
        unitlabel.setLayoutData((Object)data);
        unitlabel.setText(unit);
        unitlabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        unitlabel.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        return combo;
    }

    private void initComboBoxes() {
        if (this.systemRateCombo != null) {
            this.systemRateCombo.initCombo();
            this.systemRateCombo.add("100");
            this.systemRateCombo.add("200");
            this.systemRateCombo.add("500");
            this.systemRateCombo.add("1000");
            this.systemRateCombo.select(3);
            this.systemRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
        if (this.functionRateCombo != null) {
            this.functionRateCombo.initCombo();
            this.functionRateCombo.add("10");
            this.functionRateCombo.add("50");
            this.functionRateCombo.add("100");
            this.functionRateCombo.add("200");
            this.functionRateCombo.select(0);
            this.functionRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
        if (this.screenshotRateCombo != null) {
            this.screenshotRateCombo.initCombo();
            this.screenshotRateCombo.add("1");
            this.screenshotRateCombo.add("2");
            this.screenshotRateCombo.add("5");
            this.screenshotRateCombo.add("10");
            this.screenshotRateCombo.select(0);
            this.screenshotRateCombo.addSelectionListener(new DACustomComboSelectionListener(){

                public void selectionEvent(DACustomCombo combo) {
                }
            });
        }
    }

    private void disableConfiguration() {
        this.systemRateCombo.setEnabled(false);
        this.functionRateCombo.setEnabled(false);
        this.periodicallyToggle.setButtonEnabled(false);
        this.screenshotRateCombo.setEnabled(false);
        this.onSceneTransitionToggle.setButtonEnabled(false);
        this.leakSanitizerToggle.setButtonEnabled(false);
    }
}

