/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.nl.TargetDialogLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class TargetDialogInfoPage
extends DABaseComposite {
    private static final int TextLength = 40;
    private Composite infoParentComp = null;
    private Composite deviceInfoComp = null;
    private Composite appInfoComp = null;
    private DeviceInfo selectedDev = null;
    private AppInfo selectedApp = null;

    public TargetDialogInfoPage(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.infoParentComp = parent;
    }

    public void drawDeviceInfoPage(DeviceInfo curDev) {
        if (this.deviceInfoComp != null) {
            this.deviceInfoComp.dispose();
            this.deviceInfoComp = null;
        }
        this.selectedDev = curDev;
        this.deviceInfoComp = new Composite(this.infoParentComp, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 38);
        data.left = new FormAttachment(0, 40);
        data.right = new FormAttachment(100, 0);
        data.height = 180;
        this.deviceInfoComp.setLayoutData((Object)data);
        this.deviceInfoComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.deviceInfoComp.setLayout((Layout)new FormLayout());
        if (curDev != null) {
            this.createDevInfoLabels(this.deviceInfoComp, curDev);
        }
        this.infoParentComp.layout(true);
        this.deviceInfoComp.layout();
    }

    public void drawAppInfoPage(AppInfo curApp) {
        if (this.appInfoComp != null) {
            this.appInfoComp.dispose();
            this.appInfoComp = null;
        }
        this.selectedApp = curApp;
        this.appInfoComp = new Composite(this.infoParentComp, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 238);
        data.left = new FormAttachment(0, 40);
        data.right = new FormAttachment(100, 0);
        data.height = 230;
        this.appInfoComp.setLayoutData((Object)data);
        this.appInfoComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.appInfoComp.setLayout((Layout)new FormLayout());
        if (curApp != null) {
            this.createAppInfoLabels(this.appInfoComp);
        }
        this.infoParentComp.layout(true);
        this.appInfoComp.layout();
    }

    public DeviceInfo getSelectedDevice() {
        return this.selectedDev;
    }

    public AppInfo getSelectedApp() {
        return this.selectedApp;
    }

    /*
     * Loose catch block
     */
    private void createDevInfoLabels(Composite deviceComp, DeviceInfo curDev) {
        Label deviceLabel = new Label(deviceComp, 16384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 25;
        deviceLabel.setLayoutData((Object)data);
        deviceLabel.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        deviceLabel.setFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        deviceLabel.setText(TargetDialogLabels.DEVICE);
        RowLayout rowlayout = new RowLayout(512);
        rowlayout.justify = true;
        rowlayout.fill = true;
        Composite leftComp = new Composite(deviceComp, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)deviceLabel, 0);
        data.left = new FormAttachment(0, 10);
        data.bottom = new FormAttachment(100, 0);
        data.width = 160;
        leftComp.setLayoutData((Object)data);
        leftComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        leftComp.setLayout((Layout)rowlayout);
        this.createLabel(leftComp, TargetDialogLabels.PLATFORM_VERSION);
        this.createLabel(leftComp, TargetDialogLabels.MODEL_NAME);
        this.createLabel(leftComp, TargetDialogLabels.RAM);
        this.createLabel(leftComp, String.valueOf(TargetDialogLabels.BINARY_INFO) + "\n  ");
        Composite rightComp = new Composite(deviceComp, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)deviceLabel, 0);
        data.left = new FormAttachment((Control)leftComp, 15);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        rightComp.setLayoutData((Object)data);
        rightComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        rightComp.setLayout((Layout)rowlayout);
        String version = "unknown";
        String modelname = "unknown";
        String ram = "unknown";
        String binaryinfo = "unknown";
        try {
            try {
                version = curDev.getIDevice().getPlatformInfo().getPlatformVersion();
                modelname = curDev.getIDevice().getPlatformInfo().getModelName();
                ram = Formatter.toByteFormat((long)curDev.getDeviceStatusInfo().getSystemMemorySize());
                binaryinfo = TargetDialogInfoPage.getBinaryInfo(curDev.getIDevice());
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                this.createLabel(rightComp, version);
                this.createLabel(rightComp, modelname);
                this.createLabel(rightComp, ram);
                this.createLabel(rightComp, binaryinfo);
            }
            catch (SdbCommandRejectedException e) {
                e.printStackTrace();
                this.createLabel(rightComp, version);
                this.createLabel(rightComp, modelname);
                this.createLabel(rightComp, ram);
                this.createLabel(rightComp, binaryinfo);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.createLabel(rightComp, version);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.createLabel(rightComp, modelname);
                this.createLabel(rightComp, ram);
                this.createLabel(rightComp, binaryinfo);
            }
        }
        finally {
            this.createLabel(rightComp, version);
            this.createLabel(rightComp, modelname);
            this.createLabel(rightComp, ram);
            this.createLabel(rightComp, binaryinfo);
        }
    }

    public static String getBinaryInfo(IDevice iDevice) {
        String binaryinfo = "unknown";
        String checkstr = "Build=";
        final ArrayList checkbinaryResult = new ArrayList();
        CommunicatorUtils.execShellCommand(iDevice, "cat /etc/info.ini", (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                int i = 0;
                while (i < appLines.length) {
                    checkbinaryResult.add(appLines[i]);
                    ++i;
                }
            }
        });
        if (!checkbinaryResult.isEmpty()) {
            for (String outstring : checkbinaryResult) {
                if (!outstring.contains(checkstr)) continue;
                binaryinfo = outstring.substring(checkstr.length());
                if (binaryinfo.length() > 40) {
                    String tempStr = String.valueOf(binaryinfo.substring(0, 40)) + "\n";
                    binaryinfo = tempStr = String.valueOf(tempStr) + binaryinfo.substring(40);
                    break;
                }
                binaryinfo = String.valueOf(binaryinfo) + "\n  ";
                break;
            }
        }
        return binaryinfo;
    }

    private void createAppInfoLabels(Composite appComp) {
        Label applicationLabel = new Label(appComp, 16384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 25;
        applicationLabel.setLayoutData((Object)data);
        applicationLabel.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        applicationLabel.setFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        applicationLabel.setText(TargetDialogLabels.APPLICATION);
        RowLayout rowlayout = new RowLayout(512);
        rowlayout.justify = true;
        rowlayout.fill = true;
        Composite leftComp = new Composite(appComp, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)applicationLabel, 0);
        data.left = new FormAttachment(0, 10);
        data.bottom = new FormAttachment(100, 0);
        data.width = 160;
        leftComp.setLayoutData((Object)data);
        leftComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        leftComp.setLayout((Layout)rowlayout);
        this.createLabel(leftComp, TargetDialogLabels.APPLICATION_IDENTIFIER);
        this.createLabel(leftComp, TargetDialogLabels.PACKAGE_IDENTIFIER);
        this.createLabel(leftComp, TargetDialogLabels.PACKAGE_VERSION);
        this.createLabel(leftComp, TargetDialogLabels.PACKAGE_INSTALLED_TIME);
        this.createLabel(leftComp, String.valueOf(TargetDialogLabels.ALLPLICATION_EXEC_PATH) + "\n   ");
        Composite rightComp = new Composite(appComp, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)applicationLabel, 0);
        data.left = new FormAttachment((Control)leftComp, 15);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        rightComp.setLayoutData((Object)data);
        rightComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        rightComp.setLayout((Layout)rowlayout);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PackageInfo selectedPkg = this.selectedDev.getPkgInfoByPkgID(this.selectedApp.getPackageID());
        this.createLabel(rightComp, this.selectedApp.getAppID());
        this.createLabel(rightComp, this.selectedApp.getPackageID());
        this.createLabel(rightComp, selectedPkg.getVersion());
        this.createLabel(rightComp, dateFormat.format(new Date(selectedPkg.getInstallTime() * 1000L)));
        String appPath = this.selectedApp.getExecPath();
        if (appPath.length() > 40) {
            String tempStr = String.valueOf(appPath.substring(0, 40)) + "\n";
            appPath = tempStr = String.valueOf(tempStr) + appPath.substring(40);
        } else {
            appPath = String.valueOf(appPath) + "\n";
        }
        this.createLabel(rightComp, appPath);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        label.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        label.setText(text);
        return label;
    }
}

