/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.IRenderer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.IDECommunicator;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.listeners.TableTooltipListener;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.FindProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTable;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryStatisticsTable;
import org.tizen.dynamicanalyzer.ui.widgets.DAGrid;
import org.tizen.dynamicanalyzer.ui.widgets.FilterDialog;
import org.tizen.dynamicanalyzer.ui.widgets.SearchDialog;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableEmptyCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableEmptyColumnHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATablePopupMenu;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableRegistry;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.helper.WidgetUtils;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public abstract class DATableComposite
extends Composite {
    protected static final int START_TIME = 0;
    protected static final int END_TIME = 1;
    protected String tableName = "";
    protected DATableComposite me = null;
    protected static FindProperty findProferty;
    protected boolean ctrlPressed = false;
    protected List<FilterProperty> filterPropertyList;
    protected Grid table;
    protected List<TableInput> filteredTable = new ArrayList<TableInput>();
    protected List<TableInput> tableClone = new ArrayList<TableInput>();
    protected boolean isFilter = false;
    private static String POPUP_FILTER_BY;
    private static String POPUP_SHOW_ALL_ITEMS;
    protected List<Integer> selectionIndex;
    protected HashMap<Long, Long> selection;
    protected TableTooltipListener tableListener;
    protected boolean isTree = false;
    protected long focusSeq = -1L;
    protected Color rangeColor = ColorResources.TABLE_RANGE_COLOR_RANGE;
    protected Color secondSelectionColor = ColorResources.TABLE_RANGE_COLOR_SECOND_SELECTION;
    protected Color intersectColor = ColorResources.TABLE_RANGE_COLOR_RANGE_SECOND;
    protected DefaultTableComparator comparator = null;
    protected int[] sortTypes = null;
    protected int[] columnAlignment = null;
    protected boolean findEnabled = true;
    protected String[] columnNames = null;
    protected boolean autoColumnPack = true;
    protected DAPopupMenu popupMenu = null;
    protected Point mousePoint = new Point(0, 0);
    protected int totalColumnSize = 0;
    private int itemHeightSize = 16;
    protected double[] columnWeights;
    private boolean mousePressed;
    public volatile int taskQueueSize = 0;
    protected static final Image filterImg;
    protected static final int filterImgOffset = 12;
    private static final int MINIMAL_COLUMN_SIZE = 30;

    static {
        POPUP_FILTER_BY = "Filter by selected ";
        POPUP_SHOW_ALL_ITEMS = "Show all items";
        filterImg = ImageResources.COLUMN_FILTER_NORMAL;
    }

    public DATableComposite(Composite parent, int style) {
        this(parent, 0, style);
    }

    public DATableComposite(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        this.table = this.createGrid(tableStyle);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLineColor(ColorResources.TABLE_LINE);
        this.table.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        this.table.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.table.setFont(FontResources.TABLE_CELL_FONT);
        this.table.setEmptyColumnHeaderRenderer((IRenderer)new DATableEmptyColumnHeaderRenderer());
        this.table.setEmptyCellRenderer((GridCellRenderer)new DATableEmptyCellRenderer());
        this.table.setItemHeight(this.getItemHeightSize());
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                DATableComposite.this.mousePressed = false;
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    DATableComposite.this.mousePressed = true;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.setTableLayout();
        this.addMouseMoveListener();
        this.addMouseWheelListener();
        this.addSelectionListener();
        this.addKeyListener();
        this.addCopyItemsToPopup();
        this.me = this;
        this.setTableToolTipListener(new TableTooltipListener(this.table));
        this.applyFilterImage();
        DATableRegistry.addTable(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DATableRegistry.removeTable(DATableComposite.this.me);
            }
        });
    }

    protected Grid createGrid(int tableStyle) {
        return new DAGrid(this, tableStyle);
    }

    protected void setTableLayout() {
    }

    protected void addMouseWheelListener() {
    }

    protected void addMouseMoveListener() {
        this.table.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                DATableComposite.this.mousePoint.x = event.x;
                DATableComposite.this.mousePoint.y = event.y;
                if (DATableComposite.this.mousePressed) {
                    DATableComposite.this.calculateNewWidth(DATableComposite.this.table.getSize().x);
                }
            }
        });
    }

    protected void addSelectionListener() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0 || !(ti[0].getData() instanceof DATableDataFormat)) {
                    return;
                }
                GridItem focusedItem = ((Grid)e.widget).getFocusItem();
                if (focusedItem != null) {
                    if (!(focusedItem.getData() instanceof DATableDataFormat)) {
                        return;
                    }
                    DATableDataFormat td = (DATableDataFormat)focusedItem.getData();
                    if (td == null) {
                        return;
                    }
                    DATableComposite.this.focusSeq = td.getSelectionKey();
                }
                int size = ti.length;
                HashMap<Long, Long> sel = DATableComposite.this.getSelections();
                sel.clear();
                int i = 0;
                while (i < size) {
                    long seq;
                    DATableDataFormat tableData = (DATableDataFormat)ti[i].getData();
                    if (tableData != null && -1L != (seq = tableData.getSelectionKey())) {
                        sel.put(seq, seq);
                    }
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DATableComposite.this.activateParentTab();
            }
        });
    }

    protected void addKeyListener() {
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (262144 == e.keyCode) {
                    DATableComposite.this.ctrlPressed = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (262144 == e.keyCode) {
                    DATableComposite.this.ctrlPressed = true;
                } else if (e.keyCode == 102) {
                    if (DATableComposite.this.ctrlPressed) {
                        DATableComposite.this.ctrlPressed = false;
                        if (DATableComposite.this.findEnabled) {
                            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                            SearchDialog dialog = new SearchDialog(shell, DATableComposite.this.me);
                            dialog.open();
                        }
                    }
                } else if ((e.keyCode == 99 || e.keyCode == 0x1000009) && DATableComposite.this.ctrlPressed) {
                    DATableComposite.this.ctrlPressed = false;
                    DATableComposite.this.copySelectionToCliboard();
                }
            }
        });
    }

    private void addCopyItemsToPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = new DATablePopupMenu(this.table);
            this.popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        }
        if (this.popupMenu.getItems() != null && !this.popupMenu.getItems().isEmpty()) {
            new DAPopupMenuItem(this.popupMenu, 1);
        }
        DAPopupMenuItem copy = new DAPopupMenuItem(this.popupMenu);
        copy.setText("Copy");
        copy.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                DATableComposite.this.copySelectionToCliboard();
            }
        });
        DAPopupMenuItem export = new DAPopupMenuItem(this.popupMenu);
        export.setText("Export to file");
        export.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                DATableComposite.this.exportTableToFile();
            }
        });
    }

    private void copySelectionToCliboard() {
        Clipboard clip = new Clipboard(this.getDisplay());
        String txt = this.getFormatedString(this.table.getSelection(), "\t");
        Object[] textData = new Object[]{txt};
        Transfer[] textTransfer = new Transfer[]{TextTransfer.getInstance()};
        clip.setContents(textData, textTransfer);
    }

    private void exportTableToFile() {
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setFilterPath(PathManager.DA_SAVE_PATH);
        fd.setText("Export table to file");
        fd.setFileName(String.valueOf(Project.constructSaveName(this.getTableName(), new Date())) + ".tsv");
        String path = fd.open();
        if (path == null) {
            return;
        }
        File dest = new File(path);
        String txt = this.getFormatedString(this.table.getItems(), "\t");
        if (dest.exists() && !dest.delete()) {
            UIActionHolder.getUIAction().showWarning(String.valueOf(UserErrorWarningLabels.ERR_FAILED_TO_DELETE_FILE) + ' ' + path);
            Logger.info((Object)(String.valueOf(UserErrorWarningLabels.ERR_FAILED_TO_DELETE_FILE) + ' ' + path));
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileWriter fo = new FileWriter(dest);){
                fo.write(txt);
                fo.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERR_FAILED_TO_WRITE_TO_FILE);
            Logger.error((Object)e);
        }
    }

    private String getFormatedString(GridItem[] source, String delimiter) {
        StringBuilder sb = new StringBuilder();
        GridItem[] gridItemArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            int i = 0;
            while (i < this.table.getColumnCount()) {
                if (this.table.getColumn(i).isVisible()) {
                    if (item.getText(i).contains(delimiter)) {
                        sb.append('\"');
                        sb.append(item.getText(i));
                        sb.append('\"');
                    } else {
                        sb.append(item.getText(i));
                    }
                    sb.append(delimiter);
                }
                ++i;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(CommonConstants.NEW_LINE);
            ++n2;
        }
        return sb.toString();
    }

    public void setTree(boolean tree) {
        this.isTree = tree;
    }

    public void setFindEnabled(boolean enabled) {
        this.findEnabled = enabled;
    }

    public void setTableToolTipListener(TableTooltipListener tableListener) {
        this.tableListener = tableListener;
        if (tableListener == null) {
            return;
        }
        this.table.addListener(12, (Listener)tableListener);
        this.table.addListener(1, (Listener)tableListener);
        this.table.addListener(2, (Listener)tableListener);
        this.table.addListener(6, (Listener)tableListener);
        this.table.addListener(7, (Listener)tableListener);
        this.table.addListener(5, (Listener)tableListener);
        this.table.addListener(32, (Listener)tableListener);
        this.table.addListener(4, (Listener)tableListener);
        this.table.addListener(8, (Listener)tableListener);
    }

    public void setTableToolTipEnable(boolean enabled) {
        this.tableListener.setEnable(enabled);
    }

    public void setRangeColor(Color color) {
        this.rangeColor = color;
    }

    public void setSecondSelectionColor(Color color) {
        this.secondSelectionColor = color;
    }

    public void setIntersectColor(Color color) {
        this.intersectColor = color;
    }

    public void setColumns(String[] columnNames) {
        this.columnNames = columnNames;
        int size = columnNames.length;
        int i = 0;
        while (i < size) {
            GridColumn column = new GridColumn(this.table, 0);
            column.setText(columnNames[i]);
            if (this.isTree && i == 0) {
                column.setTree(true);
            }
            column.setCellRenderer((GridCellRenderer)new DATableCellRenderer());
            column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
            if (this.columnAlignment != null && this.columnAlignment.length > i) {
                column.setAlignment(this.columnAlignment[i]);
            }
            column.pack();
            final int columnIndex = i++;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (DATableComposite.this.checkAndOpenFilterDialog(columnIndex)) {
                        return;
                    }
                    if (DATableComposite.this.comparator != null && DATableComposite.this.sortTypes != null) {
                        DATableComposite.this.comparator.setType(DATableComposite.this.sortTypes[columnIndex]);
                        DATableComposite.this.comparator.setColumn(columnIndex);
                        DATableComposite.this.comparator.reverseDirection();
                        DATableComposite.this.updateTable();
                    }
                }
            });
        }
        this.initFilterPopupMenu();
    }

    public void setColumns(String[] columnNames, int[] headerAlignmentStyle) {
        this.setColumns(columnNames);
        if (columnNames.length != headerAlignmentStyle.length) {
            Logger.error((Object)"Count of columnNames is not the same as the count of headerAlignmentStyle!");
            return;
        }
        int i = 0;
        while (i < columnNames.length) {
            GridColumn column = this.table.getColumn(i);
            column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer(headerAlignmentStyle[i]));
            ++i;
        }
    }

    public List<String> getColumnsName() {
        ArrayList<String> dbColumnsName = new ArrayList<String>();
        if (this.columnNames == null || this.columnNames.length < 1) {
            Logger.debug((Object)"tableName is null");
        } else {
            int i = 0;
            while (i < this.columnNames.length) {
                dbColumnsName.add(this.columnNames[i]);
                ++i;
            }
        }
        return dbColumnsName;
    }

    public boolean[] getColumnVisibility() {
        if (this.table == null) {
            return null;
        }
        GridColumn[] columns = this.table.getColumns();
        int size = columns.length;
        boolean[] columnsVisibility = new boolean[size];
        int i = 0;
        while (i < size) {
            columnsVisibility[i] = columns[i].getVisible();
            ++i;
        }
        return columnsVisibility;
    }

    public void setColumnVisibility(boolean[] columnVisibility) {
        if (this.table == null || columnVisibility == null) {
            return;
        }
        int size = columnVisibility.length;
        GridColumn[] columns = this.table.getColumns();
        if (size != columns.length) {
            return;
        }
        int i = 0;
        while (i < size) {
            columns[i].setVisible(columnVisibility[i]);
            ++i;
        }
    }

    public void setColumnSize(int[] columnSizes) {
        if (this.table == null || columnSizes == null) {
            return;
        }
        int size = columnSizes.length;
        GridColumn[] columns = this.table.getColumns();
        if (size != columns.length) {
            return;
        }
        this.totalColumnSize = 0;
        int i = 0;
        while (i < size) {
            if (columnSizes[i] == 0) {
                columns[i].pack();
            } else {
                columns[i].setWidth(columnSizes[i]);
            }
            this.totalColumnSize += columnSizes[i];
            ++i;
        }
    }

    public Grid getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable() {
        GridItem[] selections = this.table.getSelection();
        ArrayList<Long> selSeqs = new ArrayList<Long>();
        int i = 0;
        while (i < selections.length) {
            DATableDataFormat tableData = (DATableDataFormat)selections[i].getData();
            LogData data = tableData.getLogData();
            if (data != null) {
                selSeqs.add(data.getSeq());
            } else {
                selSeqs.add(tableData.getSelectionKey());
            }
            ++i;
        }
        this.table.removeAll();
        this.tableClone.clear();
        List<TableInput> input = null;
        if (this.isFilter) {
            input = this.filteredTable;
            this.enableFiltering(false);
        } else {
            input = this.makeTableInput();
            this.enableFiltering(true);
        }
        if (input == null || input.isEmpty()) {
            return;
        }
        this.tableClone.addAll(input);
        if (this.comparator != null) {
            this.sortTable(input);
        }
        int[] sels = new int[selSeqs.size()];
        int iii = 0;
        int focusIndex = -1;
        int size = input.size();
        int i2 = 0;
        while (i2 < size) {
            if ((this instanceof MemoryPersistentAllocationsTable || this instanceof MemoryStatisticsTable) && i2 % 300 == 0) {
                DATableComposite dATableComposite = this;
                synchronized (dATableComposite) {
                    if (this.taskQueueSize > 1) {
                        return;
                    }
                }
            }
            GridItem gridItem = new GridItem(this.table, 0);
            DATableDataFormat gridData = (DATableDataFormat)input.get(i2).getData();
            gridItem.setData((Object)gridData);
            List<String> text = input.get(i2).getText();
            List<Image> images = input.get(i2).getImages();
            int columnCount = text.size();
            int index = 0;
            while (index < columnCount) {
                gridItem.setText(index, text.get(index));
                if (images != null && !images.isEmpty()) {
                    gridItem.setImage(index, images.get(index));
                }
                ++index;
            }
            if (input.get(i2).isInRange() && input.get(i2).isSecondSelection()) {
                gridItem.setBackground(this.intersectColor);
            } else if (input.get(i2).isSecondSelection()) {
                gridItem.setBackground(this.secondSelectionColor);
            } else if (input.get(i2).isInRange()) {
                gridItem.setBackground(this.rangeColor);
            }
            if (!this.isTree && input.get(i2).isFailed()) {
                gridItem.setBackground(ColorResources.TABLE_CONTENTS_FAILED_BACGOUND_COLOR);
                gridItem.setForeground(ColorResources.TABLE_CONTENTS_FAILED_FONT_COLOR);
                gridItem.setImage(0, ImageResources.FAILED_API_ICON_TABLE);
            }
            if (gridData != null) {
                long seqNum = gridData.getSelectionKey();
                int ii = 0;
                while (ii < selSeqs.size()) {
                    if (seqNum == (Long)selSeqs.get(ii)) {
                        sels[iii++] = i2;
                        selSeqs.remove(ii);
                    }
                    ++ii;
                }
                if (-1L != this.focusSeq && seqNum == this.focusSeq) {
                    focusIndex = i2;
                }
            }
            ++i2;
        }
        this.table.setSelection(sels);
        if (this.table.isFocusControl() && focusIndex > 0) {
            this.table.setFocusItem(this.table.getItem(focusIndex));
        }
        this.table.update();
    }

    protected void sortTable(List<? extends TableInput> input) {
        GridColumn c = this.table.getColumn(this.comparator.column);
        if (c.getImage() != null && ImageResources.FILTER_IMAGES.contains(c.getImage())) {
            return;
        }
        GridColumn[] gridColumnArray = this.table.getColumns();
        int n = gridColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn column = gridColumnArray[n2];
            if (!c.equals(column)) {
                column.setSort(0);
                if (!ImageResources.FILTER_IMAGES.contains(column.getImage())) {
                    column.setImage(null);
                }
            }
            ++n2;
        }
        c.setSort(this.comparator.dirUp ? 128 : 1024);
        Collections.sort(input, this.comparator);
    }

    protected abstract List<TableInput> makeTableInput();

    public HashMap<Long, Long> getSelections() {
        if (this.selection == null) {
            this.selection = new HashMap();
        }
        return this.selection;
    }

    public List<Integer> getSelectionIndex() {
        if (this.selectionIndex == null) {
            this.selectionIndex = new ArrayList<Integer>();
        }
        return this.selectionIndex;
    }

    public void setSelectionByPredicate(Predicate<GridItem> select) {
        ArrayList<GridItem> selectionList = new ArrayList<GridItem>();
        GridItem[] items = this.table.getItems();
        int lastSelectedIndex = 0;
        int i = 0;
        while (i < items.length) {
            GridItem item = items[i];
            if (select.evaluate(item)) {
                selectionList.add(item);
                lastSelectedIndex = i;
            }
            ++i;
        }
        this.table.setSelection(selectionList.toArray(new GridItem[0]));
        if (lastSelectedIndex > 0) {
            this.table.getVerticalBar().setSelection(lastSelectedIndex - 1);
        } else {
            this.table.getVerticalBar().setSelection(0);
        }
    }

    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        if (this.filterPropertyList != null) {
            this.filterPropertyList.clear();
        }
    }

    public void setComparator(DefaultTableComparator comparator) {
        this.comparator = comparator;
    }

    public void setSortTypes(int[] types) {
        this.sortTypes = types;
        if (this.comparator != null) {
            this.comparator.setType(this.sortTypes[0]);
        }
    }

    public void setColumnAlignment(int[] columns) {
        this.columnAlignment = columns;
    }

    public void deselectAll() {
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.table.deselectAll();
    }

    protected int getScrollSelectionIndex(int selection) {
        int size = this.table.getVerticalBar().getThumb() / 2;
        int output = selection - size;
        output = output < 0 ? 0 : output;
        return output;
    }

    public int searchString(FindProperty findProperty) {
        int i;
        GridItem[] items = this.table.getItems();
        int size = items.length;
        boolean next = !findProperty.isBackward();
        int start = findProperty.getIndex();
        DATableComposite.setFindProferty(findProperty);
        int findIndex = -1;
        if (next) {
            i = start;
            while (i < size) {
                if (this.checkText(findProperty, items[i])) {
                    findIndex = i;
                    break;
                }
                ++i;
            }
            if (findIndex < 0) {
                i = 0;
                while (i < start) {
                    if (this.checkText(findProperty, items[i])) {
                        findIndex = i;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            i = start;
            while (i >= 0) {
                if (this.checkText(findProperty, items[i])) {
                    findIndex = i;
                    break;
                }
                --i;
            }
            if (findIndex < 0) {
                i = size - 1;
                while (i > start) {
                    if (this.checkText(findProperty, items[i])) {
                        findIndex = i;
                        break;
                    }
                    --i;
                }
            }
        }
        if (findIndex >= 0) {
            if (this.table.getVerticalBar() != null) {
                this.table.getVerticalBar().setSelection(this.getScrollSelectionIndex(findIndex));
            }
            this.table.setSelection(findIndex);
            DAViewComposite parentView = (DAViewComposite)WidgetUtils.getParentOfType((Composite)this, DAViewComposite.class);
            if (parentView != null) {
                parentView.showSearchSelection(findIndex);
            }
            this.updateTable();
        } else {
            this.table.deselectAll();
        }
        return findIndex;
    }

    protected boolean checkText(FindProperty findProperty, GridItem items) {
        GridColumn[] columns = this.table.getColumns();
        int columnSize = columns.length;
        String input = findProperty.getLastSearch();
        boolean wholeWord = findProperty.isWholeWord();
        boolean caseSensitive = findProperty.isCaseSensitive();
        int ii = 0;
        while (ii < columnSize) {
            String text = items.getText(ii);
            if (!caseSensitive) {
                text = text.toUpperCase();
                input = input.toUpperCase();
            }
            if (!wholeWord ? text.contains(input) : input.compareTo(text) == 0) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public static FindProperty getFindProferty() {
        if (findProferty == null) {
            findProferty = new FindProperty();
        }
        return findProferty;
    }

    public static void setFindProferty(FindProperty findProferty) {
        DATableComposite.findProferty = findProferty;
    }

    private void initFilterPropertyList() {
        if (this.filterPropertyList == null) {
            this.filterPropertyList = new ArrayList<FilterProperty>();
        }
    }

    public List<FilterProperty> getFilterPropertyList() {
        this.initFilterPropertyList();
        return Collections.unmodifiableList(this.filterPropertyList);
    }

    public void addFilterProperty(FilterProperty filterProperty) {
        this.initFilterPropertyList();
        this.filterPropertyList.add(filterProperty);
    }

    public void clearFilterPropertyList() {
        this.initFilterPropertyList();
        this.filterPropertyList.clear();
    }

    public void setContextMenu(int context) {
        if (this.popupMenu == null) {
            this.popupMenu = new DATablePopupMenu(this.table);
            this.popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        }
        if ((context & 2) != 0) {
            if (this.popupMenu.getItems() != null && !this.popupMenu.getItems().isEmpty()) {
                new DAPopupMenuItem(this.popupMenu, 1);
            }
            this.setSourceContext();
        }
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 3) {
                    List menuItems = DATableComposite.this.popupMenu.getItems();
                    int size = menuItems.size();
                    GridItem item = DATableComposite.this.table.getItem(DATableComposite.this.mousePoint);
                    int i = 0;
                    while (i < size) {
                        DAPopupMenuItem menuItem = (DAPopupMenuItem)menuItems.get(i);
                        if (menuItem.getType() != 1) {
                            DATableComposite.this.setEnableContextMenuItem(menuItem, item);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private void setEnableContextMenuItem(DAPopupMenuItem menuItem, GridItem gridItem) {
        if (gridItem == null) {
            menuItem.setEnabled(false);
            return;
        }
        String text = menuItem.getText();
        if (text.equals("View caller source")) {
            SymbolManager.SourceLine sl = this.tableListener.getCallerSourceLine(gridItem);
            if (sl == null || sl.getError() != 0) {
                menuItem.setEnabled(false);
            } else {
                menuItem.setEnabled(true);
            }
        } else if (text.equals("View declaration source")) {
            SymbolManager.SourceLine sl = this.tableListener.getDefinitionSourceLine(gridItem);
            if (sl == null || sl.getError() != 0) {
                menuItem.setEnabled(false);
            } else {
                menuItem.setEnabled(true);
            }
        } else if (text.equals("Open caller source")) {
            SymbolManager.SourceLine sl = this.tableListener.getCallerSourceLine(gridItem);
            if (sl == null || !sl.isValid() || !IDECommunicator.isConnected()) {
                menuItem.setEnabled(false);
            } else {
                menuItem.setEnabled(true);
            }
        } else if (text.equals("Open declaration source")) {
            SymbolManager.SourceLine sl = this.tableListener.getDefinitionSourceLine(gridItem);
            if (sl == null || !sl.isValid() || !IDECommunicator.isConnected()) {
                menuItem.setEnabled(false);
            } else {
                menuItem.setEnabled(true);
            }
        }
    }

    private void setSourceContext() {
        DAPopupMenuItem viewCallerItem = new DAPopupMenuItem(this.popupMenu);
        viewCallerItem.setText("View caller source");
        viewCallerItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                GridItem item = DATableComposite.this.table.getItem(new Point(DATableComposite.this.mousePoint.x, DATableComposite.this.mousePoint.y));
                SymbolManager.SourceLine sl = DATableComposite.this.tableListener.getCallerSourceLine(item);
                DATableComposite.this.tableListener.viewSource(DATableComposite.this.mousePoint.x, DATableComposite.this.mousePoint.y, sl, true);
            }
        });
        DAPopupMenuItem viewDeclarationItem = new DAPopupMenuItem(this.popupMenu);
        viewDeclarationItem.setText("View declaration source");
        viewDeclarationItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                GridItem item = DATableComposite.this.table.getItem(new Point(DATableComposite.this.mousePoint.x, DATableComposite.this.mousePoint.y));
                SymbolManager.SourceLine sl = DATableComposite.this.tableListener.getDefinitionSourceLine(item);
                DATableComposite.this.tableListener.viewSource(DATableComposite.this.mousePoint.x, DATableComposite.this.mousePoint.y, sl, true);
            }
        });
        DAPopupMenuItem openCallerItem = new DAPopupMenuItem(this.popupMenu);
        openCallerItem.setText("Open caller source");
        openCallerItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                GridItem item = DATableComposite.this.table.getItem(new Point(DATableComposite.this.mousePoint.x, DATableComposite.this.mousePoint.y));
                SymbolManager.SourceLine sl = DATableComposite.this.tableListener.getCallerSourceLine(item);
                DATableComposite.this.tableListener.openIDE(sl, item);
            }
        });
        DAPopupMenuItem openDeclarationItem = new DAPopupMenuItem(this.popupMenu);
        openDeclarationItem.setText("Open declaration source");
        openDeclarationItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                GridItem item = DATableComposite.this.table.getItem(new Point(DATableComposite.this.mousePoint.x, DATableComposite.this.mousePoint.y));
                SymbolManager.SourceLine sl = DATableComposite.this.tableListener.getDefinitionSourceLine(item);
                DATableComposite.this.tableListener.openIDE(sl, item);
            }
        });
    }

    public void setAutoColumnPackEnabled(boolean enabled) {
        this.autoColumnPack = enabled;
    }

    public boolean isAutoColumnPackEnabled() {
        return this.autoColumnPack;
    }

    public int getItemHeightSize() {
        return this.itemHeightSize;
    }

    public void setItemHeightSize(int itemHeightSize) {
        this.itemHeightSize = itemHeightSize;
        this.table.setItemHeight(itemHeightSize);
    }

    protected void applyFilterImage() {
        this.table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                GridColumn[] columns = DATableComposite.this.table.getColumns();
                List<FilterProperty> filerProperties = DATableComposite.this.getFilterPropertyList();
                int i = 0;
                while (i < filerProperties.size()) {
                    int columnIndex = filerProperties.get(i).getColumnIndex();
                    if (columns[columnIndex].isVisible()) {
                        gc.drawImage(filterImg, DATableComposite.this.getFilterImagePosition(columnIndex), 0);
                    }
                    ++i;
                }
            }
        });
    }

    protected int getFilterImagePosition(int columnIndex) {
        int position = 0;
        if (this.table.getHorizontalBar() != null && this.table.getHorizontalBar().getSelection() > 0) {
            position -= this.table.getHorizontalBar().getSelection();
        }
        GridColumn[] columns = this.table.getColumns();
        int i = 0;
        while (i <= columnIndex) {
            if (columns[i].isVisible()) {
                position += columns[i].getWidth();
            }
            ++i;
        }
        return position - 12;
    }

    protected boolean isFilterAppliedColumn(int columnIndex) {
        boolean flag = false;
        List<FilterProperty> filterProperties = this.getFilterPropertyList();
        if (!filterProperties.isEmpty()) {
            int i = 0;
            while (i < filterProperties.size()) {
                if (columnIndex == filterProperties.get(i).getColumnIndex()) {
                    flag = true;
                    break;
                }
                ++i;
            }
        }
        return flag;
    }

    protected boolean checkAndOpenFilterDialog(int columnIndex) {
        if (!this.isFilterAppliedColumn(columnIndex)) {
            return false;
        }
        int pos = this.getFilterImagePosition(columnIndex);
        if (this.mousePoint.x < pos || this.mousePoint.x > pos + 12 || this.mousePoint.y > 12) {
            return false;
        }
        Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
        FilterDialog filterDialog = new FilterDialog(shell, this.me, columnIndex);
        filterDialog.open();
        return true;
    }

    public void setDefaultSortColumn(int columnIndex, boolean isAscending) {
        if (this.comparator != null) {
            this.comparator.setColumn(columnIndex);
            this.comparator.setDirection(isAscending);
        }
    }

    protected String getFilteredColumnName(int columnIndex) {
        return null;
    }

    protected String addLowerOperation(String columnName) {
        return "lower(" + columnName + ")";
    }

    protected String makeFilterWhereClause(String columnName, String keyword) {
        return String.valueOf(columnName) + " " + "like" + " " + "'" + "%" + keyword.toLowerCase() + "%" + "'";
    }

    protected List<String> convertFilterProperty2Query(List<FilterProperty> filterList) {
        ArrayList<String> queries = new ArrayList<String>();
        int i = 0;
        while (i < filterList.size()) {
            FilterProperty prop = filterList.get(i);
            String column = this.getFilteredColumnName(prop.getColumnIndex());
            if (column != null) {
                queries.add(this.makeFilterWhereClause(column, prop.getKeyWord()));
            }
            ++i;
        }
        return queries;
    }

    protected void initFilterPopupMenu() {
        if (this.getTableName().toLowerCase().contains("callstack")) {
            return;
        }
        if (this.popupMenu == null) {
            this.popupMenu = new DATablePopupMenu(this.table);
            this.popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        }
        int i = 0;
        while (i < this.table.getColumns().length) {
            final int index = i;
            GridColumn column = this.table.getColumn(i);
            if (!(column.getText().toLowerCase().contains("seq") || column.getText().toLowerCase().contains("time") || column.getText().toLowerCase().contains("streaming is not supported") || column.getText().equals(""))) {
                DAPopupMenuItem filterByItem = new DAPopupMenuItem(this.popupMenu);
                filterByItem.setText(String.valueOf(POPUP_FILTER_BY) + column.getText());
                filterByItem.addListener(new DAPopupMenuListener(){

                    public void widgetSelected(DAPopupMenuItem menuItem) {
                        GridItem item = DATableComposite.this.table.getItem(new Point(DATableComposite.this.mousePoint.x, DATableComposite.this.mousePoint.y));
                        if (item == null) {
                            return;
                        }
                        DATableComposite.this.cleanColumnsImages();
                        DATableComposite.this.table.getColumn(index).setImage(ImageResources.DA_IC_FILTER);
                        DATableComposite.this.table.getColumn(index).setSort(0);
                        String startData = item.getText(index);
                        DATableComposite.this.filterTable(startData, index);
                    }
                });
            }
            ++i;
        }
        DAPopupMenuItem showAllItem = new DAPopupMenuItem(this.popupMenu);
        showAllItem.setText(POPUP_SHOW_ALL_ITEMS);
        showAllItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                DATableComposite.this.isFilter = false;
                DATableComposite.this.cleanColumnsImages();
                DATableComposite.this.updateTable();
            }
        });
    }

    private void cleanColumnsImages() {
        GridColumn[] gridColumnArray = this.table.getColumns();
        int n = gridColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn column = gridColumnArray[n2];
            column.setImage(null);
            ++n2;
        }
    }

    private void filterTable(String input, int categoryIndex) {
        this.isFilter = true;
        this.filteredTable.clear();
        if (this.tableClone != null) {
            for (TableInput table : this.tableClone) {
                if (!table.getText().get(categoryIndex).equals(input)) continue;
                this.filteredTable.add(table);
            }
        }
        this.updateTable();
    }

    private void enableFiltering(boolean enable) {
        if (this.popupMenu == null || this.popupMenu.getChildren() == null) {
            return;
        }
        for (DAPopupMenuItem item : this.popupMenu.getChildren()) {
            if (item == null || item.getText() == null) continue;
            if (item.getText().startsWith(POPUP_FILTER_BY)) {
                item.setEnabled(enable);
            }
            if (!item.getText().equals(POPUP_SHOW_ALL_ITEMS)) continue;
            item.setEnabled(!enable);
        }
    }

    public void clearFiltering() {
        this.table.removeAll();
        this.tableClone.clear();
        this.isFilter = false;
    }

    private void activateParentTab() {
        DATabComposite parentTab = (DATabComposite)WidgetUtils.getParentOfType((Composite)this, DATabComposite.class);
        if (parentTab != null) {
            parentTab.activateTab();
        }
    }

    public void resizeColumns(int width) {
        if (this.columnWeights == null) {
            this.setColumnWeights(width);
        }
        int[] sizes = new int[this.table.getColumnCount()];
        int i = 0;
        while (i < this.table.getColumnCount()) {
            if (this.table.getColumn(i).isVisible()) {
                int w;
                double size = this.columnWeights[i] * (double)width;
                sizes[i] = w = (int)Math.round(size);
            } else {
                sizes[i] = this.table.getColumn(i).getWidth();
            }
            ++i;
        }
        this.setColumnSize(sizes);
    }

    private void setColumnWeights(int width) {
        int nominalWidth = 0;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            if (this.table.getColumn(i).isVisible()) {
                nominalWidth += this.table.getColumn(i).getWidth();
            }
            ++i;
        }
        this.columnWeights = new double[this.table.getColumnCount()];
        i = 0;
        while (i < this.table.getColumnCount()) {
            if (this.table.getColumn(i).isVisible()) {
                double candidate = (double)this.table.getColumn(i).getWidth() / (double)nominalWidth;
                if (candidate * (double)width < 30.0) {
                    candidate = 30.0 / (double)nominalWidth;
                }
                this.columnWeights[i] = candidate;
            } else {
                this.columnWeights[i] = 0.0;
            }
            ++i;
        }
    }

    private void calculateNewWidth(int width) {
        if (this.columnWeights != null) {
            int[] oldWidth = new int[this.table.getColumnCount()];
            int i = 0;
            while (i < this.table.getColumnCount()) {
                oldWidth[i] = (int)((double)width * this.columnWeights[i]);
                ++i;
            }
            i = 0;
            while (i < this.table.getColumnCount() - 1) {
                if (this.table.getColumn(i).isVisible() && this.table.getColumn(i + 1).isVisible() && this.table.getColumn(i).getWidth() != oldWidth[i]) {
                    int cw = this.table.getColumn(i + 1).getWidth() + oldWidth[i] - this.table.getColumn(i).getWidth();
                    this.table.getColumn(i + 1).setWidth(cw);
                    break;
                }
                ++i;
            }
        }
        this.setColumnWeights(width);
        this.resizeColumns(width);
    }

    public static interface Predicate<T> {
        public boolean evaluate(T var1);
    }
}

