/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import org.eclipse.nebula.widgets.grid.AbstractRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;

public class DATableToggleRenderer
extends AbstractRenderer {
    public DATableToggleRenderer() {
        this.setSize(11, 9);
    }

    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)value;
        DATableDataFormat tableData = (DATableDataFormat)item.getData();
        String text = "";
        Font font = item.getFont(0);
        if (font == null) {
            gc.setFont(FontResources.TABLE_CELL_FONT);
        } else {
            gc.setFont(font);
        }
        String data = (String)tableData.getObject();
        text = String.valueOf(text) + data;
        if (item.hasChildren()) {
            if (this.isExpanded()) {
                Rectangle r = ImageResources.TREE_OPEN.getBounds();
                int offset = (this.getBounds().width - r.width) / 2;
                int x = this.getBounds().x + offset;
                gc.drawImage(ImageResources.TREE_OPEN, x, this.getBounds().y);
                x += r.width + 5;
                if (this.isSelected()) {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
                } else {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
                }
                gc.drawText(text, x, this.getBounds().y, true);
            } else {
                Rectangle r = ImageResources.TREE_FOLD.getBounds();
                int offset = (this.getBounds().width - r.width) / 2;
                int x = this.getBounds().x + offset;
                gc.drawImage(ImageResources.TREE_FOLD, this.getBounds().x + offset, this.getBounds().y);
                x += r.width + 5;
                if (this.isSelected()) {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
                } else {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
                }
                gc.drawText(text, x, this.getBounds().y, true);
            }
        } else {
            Rectangle r = ImageResources.TREE_OPEN.getBounds();
            int offset = (this.getBounds().width - r.width) / 2;
            int x = this.getBounds().x + offset;
            x += r.width;
            if (this.isSelected()) {
                gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
            } else {
                gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
            }
            gc.drawText(text, x, this.getBounds().y, true);
        }
    }

    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        return new Point(11, 9);
    }
}

