/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.commands;

import java.io.IOException;
import java.rmi.ConnectException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.commands.Command;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.cli.utils.Help;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.util.Logger;

public final class DevicesCommand
extends Command {
    public DevicesCommand() {
        super("devices", 0, "show list of connected devices and emulators");
    }

    @Override
    public boolean checkArgs(String[] args) {
        if (args.length == 0) {
            return true;
        }
        if (args.length > 1) {
            return false;
        }
        try {
            return TracingDevicesOptionParser.isOptionPresent(args);
        }
        catch (ParseException e) {
            System.out.println("Wrong command arguments: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void printHelp() {
        String message = String.format("  %-25s : %s%n", this.name + " " + this.optsFormat, this.helpMessage);
        try {
            Help.printHelp(message, TracingDevicesOptionParser.opts, System.out);
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
        }
    }

    private void printDevices(List<DeviceInfo> devInfoList) {
        String DEV_NAME_HEADER = "<Device Name>";
        String DEV_SERIALNUM_HEADER = "<Serial Number>";
        int maxDeviceName = "<Device Name>".length();
        for (DeviceInfo devInfo : devInfoList) {
            int len = CliInternals.getDeviceName(devInfo).length();
            if (len <= maxDeviceName) continue;
            maxDeviceName = len;
        }
        String format = String.format("  %%-%ds %%s%n", maxDeviceName);
        System.out.format(format, "<Device Name>", "<Serial Number>");
        for (DeviceInfo devInfo : devInfoList) {
            System.out.format(format, CliInternals.getDeviceName(devInfo), CliInternals.getSerialNumber(devInfo));
        }
    }

    private ExitCode processConnectedDevices() {
        List<DeviceInfo> devInfoList = CliInternals.getDevices();
        if (devInfoList.isEmpty()) {
            System.out.println("No devices connected.");
        } else {
            System.out.println("List of connected devices:");
            this.printDevices(devInfoList);
        }
        return ExitCode.EX_SUCCESS;
    }

    private ExitCode processCurrentlyTracingDevices() {
        List<DeviceInfo> devInfoList;
        try {
            devInfoList = CliInternals.getCurrentlyTracingDevices();
        }
        catch (ConnectException e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return ExitCode.EX_CONNECTION_ERROR;
        }
        if (devInfoList.isEmpty()) {
            System.out.println("No devices currently tracing.");
        } else {
            System.out.println("List of currently tracing devices:");
            this.printDevices(devInfoList);
            System.out.println();
            System.out.println("Run \"dacli stop <ip:port|serial>\" to finish tracing on device.");
        }
        return ExitCode.EX_SUCCESS;
    }

    @Override
    public ExitCode processCommand(String[] args) {
        boolean tracingDevicesRequested;
        try {
            tracingDevicesRequested = TracingDevicesOptionParser.isOptionPresent(args);
        }
        catch (ParseException e) {
            System.out.println("Wrong command arguments: " + e.getMessage());
            return ExitCode.EX_ARGUMENTS_ERROR;
        }
        if (tracingDevicesRequested) {
            return this.processCurrentlyTracingDevices();
        }
        return this.processConnectedDevices();
    }

    private static class TracingDevicesOptionParser {
        private static CommandLineParser parser = new DefaultParser();
        private static Option listTracingDevices = Option.builder((String)"u").desc("show list of devices where tracing is running").build();
        private static Options opts = new Options().addOption(listTracingDevices);

        private TracingDevicesOptionParser() {
        }

        public static boolean isOptionPresent(String[] args) throws ParseException {
            CommandLine cmdLine = parser.parse(opts, args);
            return cmdLine.hasOption(listTracingDevices.getOpt());
        }
    }
}

