/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.service.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCache
implements ICommandListener {
    private DsfSession fSession;
    private ICommandControl fCommandControl;
    private Set<IDMContext> fAvailableContexts = new HashSet<IDMContext>();
    private Map<IDMContext, HashMap<CommandInfo, CommandResultInfo>> fCachedContexts = new HashMap<IDMContext, HashMap<CommandInfo, CommandResultInfo>>();
    private ArrayList<CommandInfo> fPendingQCommandsSent = new ArrayList();
    private ArrayList<CommandInfo> fPendingQCommandsNotYetSent = new ArrayList();
    private ArrayList<CommandInfo> fPendingQWaitingForCoalescedCompletion = new ArrayList();
    private static boolean DEBUG = false;
    private static final String CACHE_TRACE_IDENTIFIER = " [CHE]";
    private static String BLANK_CACHE_TRACE_IDENTIFIER = "";

    static {
        DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debugCache"));
        int i = 0;
        while (i < CACHE_TRACE_IDENTIFIER.length()) {
            BLANK_CACHE_TRACE_IDENTIFIER = String.valueOf(BLANK_CACHE_TRACE_IDENTIFIER) + " ";
            ++i;
        }
    }

    private void debug(String message) {
        this.debug(message, "");
    }

    private void debug(String message, String prefix) {
        if (DEBUG) {
            String[] multiLine = message.split("\n");
            String blankPrefix = "";
            int i = 0;
            while (i < prefix.length()) {
                blankPrefix = String.valueOf(blankPrefix) + " ";
                ++i;
            }
            i = 0;
            while (i < multiLine.length) {
                String traceIdentifier = i == 0 ? CACHE_TRACE_IDENTIFIER + prefix : String.valueOf(BLANK_CACHE_TRACE_IDENTIFIER) + blankPrefix;
                message = String.valueOf(DsfPlugin.getDebugTime()) + traceIdentifier + " " + multiLine[i];
                while (message.length() > 100) {
                    String partial = String.valueOf(message.substring(0, 100)) + "\\";
                    message = message.substring(100);
                    System.out.println(partial);
                }
                System.out.println(message);
                ++i;
            }
        }
    }

    public CommandCache(DsfSession session, ICommandControl control) {
        this.fSession = session;
        this.fCommandControl = control;
        this.fCommandControl.addCommandListener(this);
    }

    private CommandInfo getCoalescedCommand(CommandInfo cmd) {
        for (CommandInfo currentUnsentEntry : new ArrayList<CommandInfo>(this.fPendingQCommandsNotYetSent)) {
            ICommand<ICommandResult> unsentCommand = currentUnsentEntry.getCommand();
            ICommand<ICommandResult> coalescedCmd = unsentCommand.coalesceWith(cmd.getCommand());
            if (coalescedCmd == null) continue;
            CommandInfo coalescedCmdInfo = new CommandInfo(CommandStyle.COALESCED, coalescedCmd, null);
            if (currentUnsentEntry.getCommandstyle() == CommandStyle.COALESCED) {
                for (CommandInfo waitingEntry : new ArrayList<CommandInfo>(this.fPendingQWaitingForCoalescedCompletion)) {
                    if (waitingEntry.getCoalescedCmd() != currentUnsentEntry) continue;
                    waitingEntry.setCoalescedCmd(coalescedCmdInfo);
                }
            } else {
                this.fPendingQWaitingForCoalescedCompletion.add(currentUnsentEntry);
                currentUnsentEntry.setCoalescedCmd(coalescedCmdInfo);
            }
            this.fPendingQCommandsNotYetSent.remove(currentUnsentEntry);
            this.fCommandControl.removeCommand(currentUnsentEntry.fToken);
            return coalescedCmdInfo;
        }
        return null;
    }

    public <V extends ICommandResult> void execute(ICommand<V> command, DataRequestMonitor<V> rm) {
        assert (this.fSession.getExecutor().isInExecutorThread());
        ICommand<ICommandResult> genericCommand = command;
        DataRequestMonitor<ICommandResult> genericDone = rm;
        CommandInfo cachedCmd = new CommandInfo(CommandStyle.NONCOALESCED, genericCommand, genericDone);
        final IDMContext context = genericCommand.getContext();
        if (this.fCachedContexts.get(context) != null && this.fCachedContexts.get(context).containsKey(cachedCmd)) {
            CommandResultInfo result = this.fCachedContexts.get(context).get(cachedCmd);
            this.debug(command.toString().trim());
            if (result.getStatus().getSeverity() <= 1) {
                ICommandResult v = result.getData();
                rm.setData(v);
                this.debug(v.toString());
            } else {
                rm.setStatus(result.getStatus());
                this.debug(result.getStatus().toString());
            }
            rm.done();
            return;
        }
        if (!this.isTargetAvailable(command.getContext())) {
            this.debug(command.toString().trim(), "[N/A]");
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10001, "Target not available.", null));
            rm.done();
            return;
        }
        for (CommandInfo sentCommand : this.fPendingQCommandsSent) {
            if (!sentCommand.equals(cachedCmd)) continue;
            sentCommand.getRequestMonitorList().add(genericDone);
            this.debug(command.toString().trim(), "[SNT]");
            return;
        }
        for (CommandInfo notYetSentCommand : this.fPendingQCommandsNotYetSent) {
            if (!notYetSentCommand.equals(cachedCmd)) continue;
            notYetSentCommand.getRequestMonitorList().add(genericDone);
            this.debug(command.toString().trim(), "[SND]");
            return;
        }
        CommandInfo coalescedCmd = this.getCoalescedCommand(cachedCmd);
        if (coalescedCmd != null) {
            this.fPendingQWaitingForCoalescedCompletion.add(cachedCmd);
            cachedCmd.setCoalescedCmd(coalescedCmd);
            cachedCmd = coalescedCmd;
        }
        final CommandInfo finalCachedCmd = cachedCmd;
        this.fPendingQCommandsNotYetSent.add(finalCachedCmd);
        finalCachedCmd.fToken = this.fCommandControl.queueCommand(finalCachedCmd.getCommand(), new DataRequestMonitor<ICommandResult>(ImmediateExecutor.getInstance(), null){

            @Override
            public synchronized void done() {
                if (CommandCache.this.fSession.getExecutor().isInExecutorThread()) {
                    super.done();
                } else {
                    CommandCache.this.fSession.getExecutor().execute(new DsfRunnable(){

                        public void run() {
                            this.superDone();
                        }
                    });
                }
            }

            private void superDone() {
                super.done();
            }

            @Override
            public void handleCompleted() {
                if (!CommandCache.this.fPendingQCommandsSent.remove(finalCachedCmd) && !CommandCache.this.fPendingQCommandsNotYetSent.remove(finalCachedCmd)) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Missing command");
                    }
                    return;
                }
                ICommandResult result = (ICommandResult)this.getData();
                IStatus status = this.getStatus();
                if (finalCachedCmd.getCommandstyle() == CommandStyle.COALESCED) {
                    for (CommandInfo waitingEntry : new ArrayList(CommandCache.this.fPendingQWaitingForCoalescedCompletion)) {
                        if (waitingEntry.getCoalescedCmd() != finalCachedCmd) continue;
                        CommandCache.this.fPendingQWaitingForCoalescedCompletion.remove(waitingEntry);
                        ICommandResult subResult = result.getSubsetResult(waitingEntry.getCommand());
                        CommandResultInfo subResultInfo = new CommandResultInfo(subResult, status);
                        if (CommandCache.this.fCachedContexts.get(context) != null) {
                            ((HashMap)CommandCache.this.fCachedContexts.get(context)).put(waitingEntry, subResultInfo);
                        } else {
                            HashMap<CommandInfo, CommandResultInfo> map = new HashMap<CommandInfo, CommandResultInfo>();
                            map.put(waitingEntry, subResultInfo);
                            CommandCache.this.fCachedContexts.put(context, map);
                        }
                        if (!this.isSuccess()) {
                            for (DataRequestMonitor<ICommandResult> pendingRM : waitingEntry.getRequestMonitorList()) {
                                pendingRM.setStatus(status);
                                pendingRM.done();
                            }
                            continue;
                        }
                        if (!$assertionsDisabled && subResult == null) {
                            throw new AssertionError();
                        }
                        Iterator<DataRequestMonitor<ICommandResult>> iterator = waitingEntry.getRequestMonitorList().iterator();
                        while (iterator.hasNext()) {
                            DataRequestMonitor<ICommandResult> pendingRM;
                            DataRequestMonitor<ICommandResult> vPendingRM = pendingRM = iterator.next();
                            vPendingRM.setData(subResult);
                            vPendingRM.done();
                        }
                    }
                } else {
                    if (CommandCache.this.isTargetAvailable(context)) {
                        CommandResultInfo resultInfo = new CommandResultInfo(result, status);
                        if (CommandCache.this.fCachedContexts.get(context) != null) {
                            ((HashMap)CommandCache.this.fCachedContexts.get(context)).put(finalCachedCmd, resultInfo);
                        } else {
                            HashMap map = new HashMap();
                            map.put(finalCachedCmd, resultInfo);
                            CommandCache.this.fCachedContexts.put(context, map);
                        }
                    }
                    if (!this.isSuccess()) {
                        for (DataRequestMonitor<ICommandResult> pendingRM : finalCachedCmd.getRequestMonitorList()) {
                            pendingRM.setStatus(status);
                            pendingRM.done();
                        }
                    } else {
                        ICommandResult vResult = result;
                        Iterator<DataRequestMonitor<ICommandResult>> iterator = finalCachedCmd.getRequestMonitorList().iterator();
                        while (iterator.hasNext()) {
                            DataRequestMonitor<ICommandResult> pendingRM;
                            DataRequestMonitor<ICommandResult> vPendingRM = pendingRM = iterator.next();
                            vPendingRM.setData(vResult);
                            vPendingRM.done();
                        }
                    }
                }
            }
        });
    }

    public void setContextAvailable(IDMContext context, boolean isAvailable) {
        if (isAvailable) {
            this.fAvailableContexts.add(context);
        } else {
            this.fAvailableContexts.remove(context);
            Iterator<IDMContext> itr = this.fAvailableContexts.iterator();
            while (itr.hasNext()) {
                if (!DMContexts.isAncestorOf(context, itr.next())) continue;
                itr.remove();
            }
        }
    }

    public boolean isTargetAvailable(IDMContext context) {
        for (IDMContext availableContext : this.fAvailableContexts) {
            if (!context.equals(availableContext) && !DMContexts.isAncestorOf(context, availableContext)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.fCachedContexts.clear();
    }

    @Override
    public void commandRemoved(ICommandToken token) {
    }

    @Override
    public void commandQueued(ICommandToken token) {
    }

    @Override
    public void commandDone(ICommandToken token, ICommandResult result) {
    }

    @Override
    public void commandSent(ICommandToken token) {
        ICommand<ICommandResult> genericCommand = token.getCommand();
        CommandInfo cachedCmd = new CommandInfo(CommandStyle.NONCOALESCED, genericCommand, null);
        for (CommandInfo unqueuedCommand : new ArrayList<CommandInfo>(this.fPendingQCommandsNotYetSent)) {
            if (!unqueuedCommand.equals(cachedCmd)) continue;
            this.fPendingQCommandsNotYetSent.remove(unqueuedCommand);
            this.fPendingQCommandsSent.add(unqueuedCommand);
            break;
        }
    }

    public void reset(IDMContext dmc) {
        if (dmc == null) {
            this.fCachedContexts.clear();
            return;
        }
        Iterator<IDMContext> itr = this.fCachedContexts.keySet().iterator();
        while (itr.hasNext()) {
            IDMContext keyDmc = itr.next();
            if (keyDmc == null || !dmc.equals(keyDmc) && !DMContexts.isAncestorOf(keyDmc, dmc)) continue;
            itr.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommandInfo {
        private final List<DataRequestMonitor<ICommandResult>> fCurrentRequestMonitors;
        private final ICommand<ICommandResult> fCommand;
        private final CommandStyle fCmdStyle;
        private CommandInfo fCoalescedCmd;
        private ICommandToken fToken;

        public CommandInfo(CommandStyle cmdstyle, ICommand<ICommandResult> cmd, DataRequestMonitor<ICommandResult> rm) {
            this.fCmdStyle = cmdstyle;
            this.fCommand = cmd;
            this.fCurrentRequestMonitors = new LinkedList<DataRequestMonitor<ICommandResult>>();
            this.fCurrentRequestMonitors.add(rm);
            this.fCoalescedCmd = null;
        }

        public CommandStyle getCommandstyle() {
            return this.fCmdStyle;
        }

        public List<DataRequestMonitor<ICommandResult>> getRequestMonitorList() {
            return this.fCurrentRequestMonitors;
        }

        public ICommand<ICommandResult> getCommand() {
            return this.fCommand;
        }

        public CommandInfo getCoalescedCmd() {
            return this.fCoalescedCmd;
        }

        public void setCoalescedCmd(CommandInfo cmd) {
            this.fCoalescedCmd = cmd;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CommandInfo)) {
                return false;
            }
            CommandInfo otherCmd = (CommandInfo)other;
            return otherCmd.fCommand.equals(this.fCommand);
        }

        public int hashCode() {
            return this.fCommand.hashCode();
        }
    }

    class CommandResultInfo {
        private final ICommandResult fData;
        private final IStatus fStatus;

        public CommandResultInfo(ICommandResult data, IStatus status) {
            this.fData = data;
            this.fStatus = status;
        }

        public ICommandResult getData() {
            return this.fData;
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CommandStyle {
        COALESCED,
        NONCOALESCED;

    }
}

