/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CPPASTCapture
extends ASTNode
implements ICPPASTCapture {
    private boolean fByReference;
    private boolean fPackExpansion;
    private IASTName fIdentifier;

    public CPPASTCapture copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTCapture copy(IASTNode.CopyStyle style) {
        CPPASTCapture result = new CPPASTCapture();
        if (this.fIdentifier != null) {
            result.setIdentifier(this.fIdentifier.copy(style));
        }
        result.fByReference = this.fByReference;
        result.fPackExpansion = this.fPackExpansion;
        result.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            result.setCopyLocation(this);
        }
        return result;
    }

    public boolean capturesThisPointer() {
        return this.fIdentifier == null;
    }

    public boolean isByReference() {
        return this.fByReference;
    }

    public boolean isPackExpansion() {
        return this.fPackExpansion;
    }

    public IASTName getIdentifier() {
        return this.fIdentifier;
    }

    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitCaptures) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fIdentifier != null && !this.fIdentifier.accept(visitor)) {
            return false;
        }
        return !visitor.shouldVisitCaptures || visitor.leave(this) != 2;
    }

    public void setIdentifier(IASTName identifier) {
        this.assertNotFrozen();
        if (identifier != null) {
            identifier.setParent(this);
            identifier.setPropertyInParent(IDENTIFIER);
        }
        this.fIdentifier = identifier;
    }

    public void setIsByReference(boolean value) {
        this.assertNotFrozen();
        this.fByReference = value;
    }

    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fPackExpansion = val;
    }
}

