/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CPPASTPointer
extends ASTNode
implements IASTPointer {
    private boolean isConst;
    private boolean isVolatile;
    private boolean isRestrict;

    public CPPASTPointer copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTPointer copy(IASTNode.CopyStyle style) {
        CPPASTPointer copy = new CPPASTPointer();
        copy.isConst = this.isConst;
        copy.isVolatile = this.isVolatile;
        copy.isRestrict = this.isRestrict;
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public void setConst(boolean value) {
        this.assertNotFrozen();
        this.isConst = value;
    }

    public void setVolatile(boolean value) {
        this.assertNotFrozen();
        this.isVolatile = value;
    }

    public void setRestrict(boolean value) {
        this.assertNotFrozen();
        this.isRestrict = value;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitPointerOperators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            if (action.leave(this) == 2) {
                return false;
            }
        }
        return true;
    }
}

