/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPClassType
extends PlatformObject
implements ICPPInternalClassTypeMixinHost {
    private IASTName definition;
    private IASTName[] declarations;
    private boolean checked = false;
    private ICPPClassType typeInIndex;

    public CPPClassType(IASTName name, IBinding indexBinding) {
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        IASTNode parent = name.getParent();
        while (parent instanceof IASTName) {
            parent = parent.getParent();
        }
        if (parent instanceof IASTCompositeTypeSpecifier) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        name.setBinding(this);
        if (indexBinding instanceof ICPPClassType && indexBinding instanceof IIndexBinding) {
            this.typeInIndex = (ICPPClassType)indexBinding;
        }
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public void checkForDefinition() {
        if (!this.checked && this.definition == null) {
            FindDefinitionAction action = new FindDefinitionAction();
            IASTNode node = CPPVisitor.getContainingBlockItem(this.getPhysicalNode()).getParent();
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                node = CPPVisitor.getContainingBlockItem(node.getParent());
            }
            while (node instanceof ICPPASTTemplateDeclaration) {
                node = node.getParent();
            }
            node.accept(action);
            this.definition = action.result;
            if (this.definition == null) {
                IIndex index;
                IASTTranslationUnit translationUnit = node.getTranslationUnit();
                translationUnit.accept(action);
                this.definition = action.result;
                if (this.definition == null && this.typeInIndex == null && (index = translationUnit.getIndex()) != null) {
                    this.typeInIndex = (ICPPClassType)((Object)index.adaptBinding(this));
                }
            }
        }
        this.checked = true;
    }

    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        if (this.definition != null) {
            IASTNode node = this.definition;
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    private ICPPASTElaboratedTypeSpecifier getElaboratedTypeSpecifier() {
        if (this.declarations != null) {
            IASTNode node = this.declarations[0];
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTElaboratedTypeSpecifier) {
                return (ICPPASTElaboratedTypeSpecifier)node;
            }
        }
        return null;
    }

    public final String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        return this.definition != null ? this.definition.getSimpleID() : this.declarations[0].getSimpleID();
    }

    public IScope getScope() {
        IASTNode node;
        IASTName name = this.definition != null ? this.definition : this.declarations[0];
        IScope scope = CPPVisitor.getContainingScope(name);
        if (this.definition == null && name.getPropertyInParent() != ICPPASTQualifiedName.SEGMENT_NAME && (!((node = this.declarations[0].getParent().getParent()) instanceof IASTSimpleDeclaration) || ((IASTSimpleDeclaration)node).getDeclarators().length != 0 || this.getElaboratedTypeSpecifier().isFriend())) {
            while (scope instanceof ICPPClassScope || scope instanceof ICPPFunctionScope) {
                try {
                    scope = scope.getParent();
                }
                catch (DOMException dOMException) {}
            }
        }
        return scope;
    }

    public ICPPClassScope getCompositeScope() {
        IScope scope;
        this.checkForDefinition();
        if (this.definition != null) {
            return this.getCompositeTypeSpecifier().getScope();
        }
        if (this.typeInIndex != null && (scope = this.typeInIndex.getCompositeScope()) instanceof ICPPClassScope) {
            return (ICPPClassScope)scope;
        }
        return null;
    }

    public IASTNode getPhysicalNode() {
        return this.definition != null ? this.definition : this.declarations[0];
    }

    public int getKey() {
        if (this.definition != null) {
            return this.getCompositeTypeSpecifier().getKey();
        }
        return this.getElaboratedTypeSpecifier().getKind();
    }

    public void addDefinition(IASTNode node) {
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            this.definition = ((ICPPASTCompositeTypeSpecifier)node).getName();
        }
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof ICPPASTElaboratedTypeSpecifier)) {
            return;
        }
        IASTName name = ((ICPPASTElaboratedTypeSpecifier)node).getName();
        if (this.declarations == null) {
            this.declarations = new IASTName[]{name};
            return;
        }
        this.declarations = this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.declarations, name) : (IASTName[])ArrayUtil.append(IASTName.class, this.declarations, name);
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    public ICPPBase[] getBases() {
        return ClassTypeHelper.getBases(this);
    }

    public IField[] getFields() {
        return ClassTypeHelper.getFields(this);
    }

    public ICPPField[] getDeclaredFields() {
        return ClassTypeHelper.getDeclaredFields(this);
    }

    public ICPPMethod[] getMethods() {
        return ClassTypeHelper.getMethods(this);
    }

    public ICPPMethod[] getAllDeclaredMethods() {
        return ClassTypeHelper.getAllDeclaredMethods(this);
    }

    public ICPPMethod[] getDeclaredMethods() {
        return ClassTypeHelper.getDeclaredMethods(this);
    }

    public ICPPConstructor[] getConstructors() {
        return ClassTypeHelper.getConstructors(this);
    }

    public IBinding[] getFriends() {
        return ClassTypeHelper.getFriends(this);
    }

    public ICPPClassType[] getNestedClasses() {
        return ClassTypeHelper.getNestedClasses(this);
    }

    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public IBinding getOwner() {
        if (this.definition != null) {
            return CPPVisitor.findNameOwner(this.definition, true);
        }
        return CPPVisitor.findDeclarationOwner(this.declarations[0], true);
    }

    public boolean isAnonymous() {
        IASTNode node;
        if (this.getNameCharArray().length > 0) {
            return false;
        }
        ICPPASTCompositeTypeSpecifier spec = this.getCompositeTypeSpecifier();
        return spec != null && (node = spec.getParent()) instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)node).getDeclarators().length == 0;
    }

    public static class CPPClassTypeProblem
    extends ProblemBinding
    implements ICPPClassType {
        public CPPClassTypeProblem(IASTName name, int id) {
            super(name, id);
        }

        public CPPClassTypeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPBase[] getBases() {
            return ICPPBase.EMPTY_BASE_ARRAY;
        }

        public IField[] getFields() {
            return IField.EMPTY_FIELD_ARRAY;
        }

        public ICPPField[] getDeclaredFields() {
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }

        public ICPPMethod[] getMethods() {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }

        public ICPPMethod[] getAllDeclaredMethods() {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }

        public ICPPMethod[] getDeclaredMethods() {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }

        public ICPPConstructor[] getConstructors() {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }

        public int getKey() {
            return 3;
        }

        public IField findField(String name) {
            return null;
        }

        public IScope getCompositeScope() {
            return this;
        }

        public IBinding[] getFriends() {
            return IBinding.EMPTY_BINDING_ARRAY;
        }

        public ICPPClassType[] getNestedClasses() {
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }
    }

    private class FindDefinitionAction
    extends ASTVisitor {
        private char[] nameArray;
        public IASTName result;

        private FindDefinitionAction() {
            this.nameArray = CPPClassType.this.getNameCharArray();
            this.result = null;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId) {
                return 1;
            }
            if (name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            char[] c = name.getLookupKey();
            if (name.getParent() instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name.getParent()).getNames();
                if (ns[ns.length - 1] != name) {
                    return 3;
                }
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTCompositeTypeSpecifier && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPClassType.this) {
                this.result = name.getLastName();
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration || declaration instanceof ICPPASTTemplateDeclaration) {
                return 3;
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTCompositeTypeSpecifier ? 3 : 1;
        }

        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

