/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacroContainerCollector
implements IBTreeVisitor {
    private final PDOMLinkage linkage;
    private final char[] matchChars;
    private final boolean prefixLookup;
    private final IContentAssistMatcher contentAssistMatcher;
    private final boolean caseSensitive;
    private IProgressMonitor monitor = null;
    private int monitorCheckCounter = 0;
    private List<PDOMMacroContainer> macros = new ArrayList<PDOMMacroContainer>();

    public MacroContainerCollector(PDOMLinkage linkage, char[] name, boolean prefixLookup, boolean contentAssistLookup, boolean caseSensitive) {
        if (contentAssistLookup) {
            IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(name);
            this.contentAssistMatcher = matcher.matchRequiredAfterBinarySearch() ? matcher : null;
            this.matchChars = matcher.getPrefixForBinarySearch();
            this.prefixLookup = true;
            this.caseSensitive = false;
        } else {
            this.contentAssistMatcher = null;
            this.matchChars = name;
            this.prefixLookup = prefixLookup;
            this.caseSensitive = caseSensitive;
        }
        this.linkage = linkage;
    }

    public void setMonitor(IProgressMonitor pm) {
        this.monitor = pm;
    }

    @Override
    public final int compare(long record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        IString rhsName = PDOMNamedNode.getDBName(this.linkage.getDB(), record);
        return this.compare(rhsName);
    }

    private int compare(IString rhsName) throws CoreException {
        int cmp;
        if (this.prefixLookup) {
            cmp = rhsName.comparePrefix(this.matchChars, false);
            if (this.caseSensitive) {
                cmp = cmp == 0 ? rhsName.comparePrefix(this.matchChars, true) : cmp;
            }
        } else {
            cmp = this.caseSensitive ? rhsName.compareCompatibleWithIgnoreCase(this.matchChars) : rhsName.compare(this.matchChars, false);
        }
        return cmp;
    }

    @Override
    public final boolean visit(long record) throws CoreException {
        if (this.monitor != null) {
            this.checkCancelled();
        }
        if (record == 0L) {
            return true;
        }
        if (this.contentAssistMatcher != null) {
            char[] nodeName = PDOMNamedNode.getDBName(this.linkage.getDB(), record).getChars();
            if (this.contentAssistMatcher.match(nodeName)) {
                this.macros.add(new PDOMMacroContainer(this.linkage, record));
            }
        } else {
            this.macros.add(new PDOMMacroContainer(this.linkage, record));
        }
        return true;
    }

    public final List<PDOMMacroContainer> getMacroList() {
        return this.macros;
    }

    private void checkCancelled() {
        if (++this.monitorCheckCounter % 4096 == 0 && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

