/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.util.Arrays;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.core.runtime.IPath;

public abstract class BinaryObjectAdapter
extends BinaryFile
implements IBinaryParser.IBinaryObject {
    protected IBinaryParser.ISymbol[] NO_SYMBOLS = new IBinaryParser.ISymbol[0];

    public BinaryObjectAdapter(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    public IBinaryParser.ISymbol getSymbol(IAddress addr) {
        Object[] syms = this.getSymbols();
        int insertion = Arrays.binarySearch(syms, addr);
        if (insertion >= 0) {
            return syms[insertion];
        }
        if (insertion == -1) {
            return null;
        }
        Object symbol = syms[(insertion = -insertion - 1) - 1];
        if (addr.compareTo(symbol.getAddress().add(symbol.getSize())) < 0) {
            return syms[insertion - 1];
        }
        return null;
    }

    public long getBSS() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.bss;
        }
        return 0L;
    }

    public String getCPU() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.cpu;
        }
        return "";
    }

    public long getData() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.data;
        }
        return 0L;
    }

    public long getText() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.text;
        }
        return 0L;
    }

    public boolean hasDebug() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.hasDebug;
        }
        return false;
    }

    public boolean isLittleEndian() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.isLittleEndian;
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.needed;
        }
        return new String[0];
    }

    public String getSoName() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.soname;
        }
        return "";
    }

    public String getName() {
        return this.getPath().lastSegment().toString();
    }

    public String toString() {
        return this.getName();
    }

    public abstract IBinaryParser.ISymbol[] getSymbols();

    public abstract IAddressFactory getAddressFactory();

    protected abstract BinaryObjectInfo getBinaryObjectInfo();

    public class BinaryObjectInfo {
        public long bss;
        public long data;
        public long text;
        public boolean hasDebug;
        public boolean isLittleEndian;
        public String soname = "";
        public String[] needed = new String[0];
        public String cpu = "";
    }
}

