/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DAAnimationIcon
extends Canvas {
    private List<Image> imageList = null;
    Timer timer = null;
    long interval = 100L;
    int index = 0;
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Canvas canvas = (Canvas)e.widget;
            canvas.setBackground(canvas.getParent().getBackground());
            Rectangle rect = canvas.getClientArea();
            if (DAAnimationIcon.this.index >= DAAnimationIcon.this.imageList.size()) {
                DAAnimationIcon.this.index = 0;
            }
            Image image = (Image)DAAnimationIcon.this.imageList.get(DAAnimationIcon.this.index++);
            Rectangle imageBounds = image.getBounds();
            e.gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, rect.x, rect.y, rect.width, rect.height);
        }
    };

    public DAAnimationIcon(Composite parent, int style) {
        super(parent, style | 0x40000000);
        this.addPaintListener(this.paintListener);
    }

    public DAAnimationIcon(Composite parent, int style, List<Image> images) {
        this(parent, style);
        this.imageList = new ArrayList<Image>();
        this.imageList.addAll(images);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void start() {
        this.startTimer();
    }

    private void startTimer() {
        if (this.timer != null) {
            this.stopTimer();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (this != null && !DAAnimationIcon.this.isDisposed()) {
                            DAAnimationIcon.this.redraw();
                            DAAnimationIcon.this.update();
                        }
                    }
                });
            }
        }, 10L, this.interval);
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

