/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class IntervalManager {
    public static final IntervalManager INSTANCE = new IntervalManager();
    private List<DAChartPlotIntervalMarker> intervalList = new ArrayList<DAChartPlotIntervalMarker>();
    private DAChartPlotIntervalMarker selectionMarker;
    private List<IntervalEventListener> listeners = new ArrayList<IntervalEventListener>();
    private static final int ALPHA = 63;

    private IntervalManager() {
        this.selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        if (Display.getCurrent() != null) {
            this.selectionMarker.setBackgroundColor(ColorResources.POINT);
            this.selectionMarker.setAlpha(63);
        }
    }

    public DAChartPlotIntervalMarker getSelectionMarker() {
        return new DAChartPlotIntervalMarker(this.selectionMarker);
    }

    public void setSelectionMarkerInterval(double start, double end) {
        if (CommonUtil.isDoublesEquals((double)this.selectionMarker.getStartVal(), (double)start) && CommonUtil.isDoublesEquals((double)this.selectionMarker.getEndVal(), (double)end)) {
            return;
        }
        this.selectionMarker.setInterval(start, end);
        this.notifyListeners();
    }

    public void addInterval(DAChartPlotIntervalMarker interval) {
        this.intervalList.add(interval);
        this.notifyListeners();
    }

    public void addInterval(double start, double end) {
        DAChartPlotIntervalMarker marker = new DAChartPlotIntervalMarker(start, end, 1);
        marker.setBackgroundColor(ColorResources.POINT);
        marker.setForegroundColor(ColorResources.POINT);
        marker.setAlpha(150);
        this.intervalList.add(marker);
    }

    public void clearIntervals() {
        this.intervalList.clear();
        this.selectionMarker.setInterval(-1.0, -1.0);
        this.notifyListeners();
    }

    public List<DAChartPlotIntervalMarker> getIntervalsToDraw() {
        ArrayList<DAChartPlotIntervalMarker> extendedList = new ArrayList<DAChartPlotIntervalMarker>();
        extendedList.addAll(this.intervalList);
        extendedList.add(this.selectionMarker);
        return extendedList;
    }

    public void removeInterval(int index) {
        this.intervalList.remove(index);
        this.notifyListeners();
    }

    public void removeIntervals() {
        this.intervalList.clear();
    }

    public void addEventListener(IntervalEventListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (IntervalEventListener listener : this.listeners) {
            listener.handleChangeEvent();
        }
    }

    public boolean isIntervalSelected() {
        return this.selectionMarker.getEndVal() - this.selectionMarker.getStartVal() > 0.0;
    }

    @FunctionalInterface
    public static interface IntervalEventListener {
        public void handleChangeEvent();
    }
}

