/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.notification;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.notification.DAPopupNotification;
import org.tizen.dynamicanalyzer.widgets.notification.IPopupNotificationRenderer;

public class DAPopupNotificationRenderer
implements IPopupNotificationRenderer {
    private static final int TEXT_LEFT_MARGIN = 95;
    private static final int TEXT_TOP_MARGIN_1L = 48;
    private static final int TEXT_TOP_MARGIN_2L = 35;
    private static final int TEXT_TOP_MARGIN_3L = 27;
    private static final int TEXT_SPACING1 = 10;
    private static final int TEXT_SPACING2 = 5;
    private static final int TEXT_HEIGHT1 = 15;
    private static final int TEXT_HEIGHT2 = 13;
    private static final int ICON_LEFT_MARGIN = 25;
    private static final int ICON_TOP_MARGIN = 30;
    private static final int TEXT_MAX_WIDTH = 200;
    private static final int UNDERLINE_OFFSET = -2;
    private static final double DETAILS_TEXT_ALPHA = 0.65;
    private static final Image BACKGROUND = ImageResources.NOTIFICATION_BG;
    private static final Image ICON = ImageResources.NOTIFICATION_ICON;
    private static final Font TITLE_FONT = FontResources.NOTIFICATION_TITLE_FONT;
    private static final Font MESSAGE_FONT = FontResources.NOTIFICATION_MESSAGE_FONT;
    private static final Region visibleRegion = DAPopupNotificationRenderer.calculateVisibleRegion();

    @Override
    public void draw(GC gc, DAPopupNotification notification) {
        gc.drawImage(BACKGROUND, 0, 0);
        gc.drawImage(ICON, 25, 30);
        this.drawAllText(gc, notification.getTitle(), notification.getMessage(), notification.getDetails());
    }

    @Override
    public Region getVisibleRegion() {
        return visibleRegion;
    }

    private static Region calculateVisibleRegion() {
        Region result = new Region();
        ImageData imageData = BACKGROUND.getImageData();
        if (imageData.alphaData == null) {
            result.add(BACKGROUND.getBounds());
        } else {
            int y = 0;
            while (y < imageData.height) {
                int x = 0;
                while (x < imageData.width) {
                    if (imageData.getAlpha(x, y) > 0) {
                        result.add(imageData.x + x, imageData.y + y, 1, 1);
                    }
                    ++x;
                }
                ++y;
            }
        }
        return result;
    }

    private void drawAllText(GC gc, String title, String message, String details) {
        if (title == null || title.isEmpty()) {
            return;
        }
        gc.setForeground(ColorResources.WHITE);
        int x = 95;
        if (message != null && !message.isEmpty()) {
            if (details != null && !details.isEmpty()) {
                int y = 27;
                this.drawText(gc, title, TITLE_FONT, x, y);
                this.drawText(gc, message, MESSAGE_FONT, x, y += 25);
                this.drawText(gc, details, MESSAGE_FONT, x, y += 18, 0.65, true);
            } else {
                int y = 35;
                this.drawText(gc, title, TITLE_FONT, x, y);
                this.drawText(gc, message, MESSAGE_FONT, x, y += 25);
            }
        } else {
            int y = 48;
            this.drawText(gc, title, TITLE_FONT, x, y);
        }
        gc.setClipping(null);
    }

    private void drawText(GC gc, String text, Font font, int x, int y) {
        gc.setFont(font);
        gc.setClipping(new Rectangle(x, y, 200, gc.textExtent((String)text).y + 3));
        gc.drawText(text, x, y, true);
    }

    private void drawText(GC gc, String text, Font font, int x, int y, double alpha, boolean underline) {
        Color fg = gc.getForeground();
        RGBA rgba = fg.getRGBA();
        rgba.alpha = (int)(255.0 * alpha);
        gc.setForeground(new Color(fg.getDevice(), rgba));
        this.drawText(gc, text, font, x, y);
        if (underline) {
            Point textSize = gc.textExtent(text);
            y = y + textSize.y + -2;
            gc.drawLine(x, y, x + textSize.x, y);
        }
    }
}

