/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.model.Streamable;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.UnsignedInt;

public class ByteUtil {
    public static int recursive_checker = 0;
    public static byte EOS = 0;
    private static final int BYTE_SIZE_INTEGER = 4;
    private static final int BYTE_SIZE_LONG = 8;
    private static final int BYTE_SIZE_DOUBLE = 8;
    private static final int BYTE_SIZE_FLOAT = 4;
    private static final int BYTE_SIZE_SHORT = 2;
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static int toInt(byte[] src, int srcPos) {
        int dword = 0;
        int i = 0;
        while (i < 4) {
            int temp = (src[i + srcPos] & 0xFF) << 8 * i;
            dword += temp;
            ++i;
        }
        return dword;
    }

    public static int toInt(byte[] src) {
        return ByteUtil.toInt(src, 0);
    }

    public static byte[] toBytes(int value) {
        byte[] result = new byte[4];
        int i = 0;
        while (i < 4) {
            result[i] = (byte)(value >> i * 8);
            ++i;
        }
        return result;
    }

    public static UnsignedInt toUnsignedInt(byte[] src, int srcPos) {
        long qword = 0L;
        int i = 0;
        while (i < 4) {
            qword = (qword << 8) + (long)(src[i + srcPos] & 0xFF);
            ++i;
        }
        long b1 = qword >> 0 & 0xFFL;
        long b2 = qword >> 8 & 0xFFL;
        long b3 = qword >> 16 & 0xFFL;
        long b4 = qword >> 24 & 0xFFL;
        return new UnsignedInt(b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0);
    }

    public static int toUnsignedShort(byte[] src, int srcPos) {
        int qword = 0;
        int i = 0;
        while (i < 2) {
            qword = (qword << 8) + (src[i + srcPos] & 0xFF);
            ++i;
        }
        int b1 = qword >> 0 & 0xFF;
        int b2 = qword >> 8 & 0xFF;
        return b1 << 8 | b2 << 0;
    }

    public static long toUIntByLong(byte[] src, int srcPos) {
        long qword = 0L;
        int i = 0;
        while (i < 4) {
            long temp = ((long)src[i + srcPos] & 0xFFL) << 8 * i;
            qword += temp;
            ++i;
        }
        return qword;
    }

    public static long toLong(byte[] src, int srcPos) {
        long qword = 0L;
        int i = 0;
        while (i < 8) {
            long temp = ((long)src[i + srcPos] & 0xFFL) << 8 * i;
            qword += temp;
            ++i;
        }
        return qword;
    }

    public static long toLong(byte[] src) {
        return ByteUtil.toLong(src, 0);
    }

    public static byte[] toBytes(long value) {
        byte[] result = new byte[8];
        int i = 0;
        while (i < 8) {
            result[i] = (byte)(value >> i * 8);
            ++i;
        }
        return result;
    }

    public static short toShort(byte[] src, int srcPos) {
        int dword = 0;
        int i = 0;
        while (i < 2) {
            int temp = (src[i + srcPos] & 0xFF) << 8 * i;
            dword += temp;
            ++i;
        }
        return (short)dword;
    }

    public static byte[] toBytes(short value) {
        byte[] result = new byte[2];
        int i = 0;
        while (i < 2) {
            result[i] = (byte)(value >> i * 8);
            ++i;
        }
        return result;
    }

    public static float toFloat(byte[] input, int from) {
        byte[] temp = new byte[4];
        System.arraycopy(input, from, temp, 0, 4);
        ByteBuffer buf = ByteBuffer.wrap(temp);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf.getFloat();
    }

    public static byte[] toBytes(float input) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putFloat(input);
        return buf.array();
    }

    public static double toDouble(byte[] input, int from) {
        byte[] temp = new byte[8];
        System.arraycopy(input, from, temp, 0, 8);
        ByteBuffer buf = ByteBuffer.wrap(temp);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf.getDouble();
    }

    public static byte[] toBytes(double input) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putDouble(input);
        return buf.array();
    }

    public static byte[] toBytesN(byte[] src, int start, int length) {
        byte[] temp = new byte[length];
        System.arraycopy(src, start, temp, 0, length);
        return temp;
    }

    public static String getString(byte[] data, int start) {
        int length = ByteUtil.getStringLength(data, start) - 1;
        String str = new String(data, start, length);
        return str;
    }

    public static int getStringLength(byte[] data, int start) {
        int i = start;
        while (i < data.length) {
            if (data[i] == 0) {
                return i - start + 1;
            }
            ++i;
        }
        Logger.error("The String data don't have the EOS '\u0000'!!!");
        return data.length - start;
    }

    public static String toString(byte[] data, int start) {
        int length = 0;
        int i = start;
        while (i < data.length) {
            if (data[i] == 0) {
                length = i - start;
                break;
            }
            ++i;
        }
        byte[] temp = new byte[length];
        System.arraycopy(data, start, temp, 0, length);
        String str = new String(temp);
        return str;
    }

    public static String toString(byte[] data, int start, int length) {
        byte[] temp = new byte[length];
        System.arraycopy(data, start, temp, 0, length);
        String str = new String(temp);
        return str;
    }

    public static byte[] toByte(String str) {
        if (str.isEmpty()) {
            byte[] temp = new byte[]{EOS};
            return temp;
        }
        int size = str.length();
        byte[] temp = null;
        if (EOS != str.charAt(size - 1)) {
            temp = new byte[size + 1];
            System.arraycopy(str.getBytes(), 0, temp, 0, size);
            temp[temp.length - 1] = EOS;
        } else {
            temp = new byte[size];
            System.arraycopy(str.getBytes(), 0, temp, 0, size);
        }
        return temp;
    }

    public static byte[] getByte(Object ... objects) {
        if (objects == null) {
            return null;
        }
        byte[] temp = new byte[]{};
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                if (obj instanceof Integer) {
                    int value = (Integer)obj;
                    temp = ByteUtil.concatByteArray(temp, ByteUtil.toBytes(value));
                } else if (obj instanceof Short) {
                    short value = (Short)obj;
                    temp = ByteUtil.concatByteArray(temp, ByteUtil.toBytes(value));
                } else if (obj instanceof Long) {
                    long value = (Long)obj;
                    temp = ByteUtil.concatByteArray(temp, ByteUtil.toBytes(value));
                } else if (obj instanceof Float) {
                    float f = ((Float)obj).floatValue();
                    temp = ByteUtil.concatByteArray(temp, ByteUtil.toBytes(f));
                } else if (obj instanceof Double) {
                    double d = (Double)obj;
                    temp = ByteUtil.concatByteArray(temp, ByteUtil.toBytes(d));
                } else if (obj instanceof String) {
                    String value = (String)obj;
                    temp = ByteUtil.concatByteArray(temp, ByteUtil.toByte(value));
                } else if (obj instanceof byte[]) {
                    temp = ByteUtil.concatByteArray(temp, (byte[])obj);
                } else if (obj instanceof List) {
                    List cfr_ignored_0 = (List)obj;
                    temp = ByteUtil.concatByteArray(temp, ByteUtil.getByteFromList((List)obj));
                }
            }
            ++n2;
        }
        return temp;
    }

    public static <T> byte[] getByteFromList(List<T> input) {
        byte[] temp = new byte[]{};
        for (T obj : input) {
            temp = obj instanceof Streamable ? ByteUtil.concatByteArray(temp, ((Streamable)obj).toByteStream()) : ByteUtil.concatByteArray(temp, obj);
        }
        return temp;
    }

    public static byte[] concatByteArray(byte[] front, byte[] rear) {
        if (front == null && rear == null) {
            return null;
        }
        if (front == null && rear != null) {
            return rear;
        }
        if (front != null && rear == null) {
            return front;
        }
        byte[] result = new byte[front.length + rear.length];
        System.arraycopy(front, 0, result, 0, front.length);
        System.arraycopy(rear, 0, result, front.length, rear.length);
        return result;
    }

    public static byte[] concatByteArray(Object ... byteArrays) {
        if (byteArrays == null) {
            return null;
        }
        byte[] temp = new byte[]{};
        Object[] objectArray = byteArrays;
        int n = byteArrays.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                temp = ByteUtil.concatByteArray(temp, ByteUtil.getByte(obj));
            }
            ++n2;
        }
        return temp;
    }

    public static String toReadableString(byte[] input) {
        return ByteUtil.toReadableString(input, 8, 16);
    }

    public static String toReadableString(byte[] input, int tabIndex, int lineIndex) {
        StringBuffer strHex = new StringBuffer();
        int i = 0;
        while (i < input.length) {
            strHex.append(String.format("%02X", input[i]));
            if (i % 16 == lineIndex - 1) {
                strHex.append(CommonConstants.NEW_LINE);
            } else if (i % 8 == tabIndex - 1) {
                strHex.append("\t");
            } else {
                strHex.append(" ");
            }
            ++i;
        }
        return strHex.toString();
    }

    public static void printByteArray(byte[] input) {
        int line = 0;
        int i = 0;
        while (i < input.length) {
            String b = String.format("%2x", input[i]);
            Logger.debug(false, (Object)(String.valueOf(b) + "  "));
            if (line == 9) {
                Logger.debug(false, (Object)"      ");
            }
            if (line == 19) {
                line = -1;
            }
            ++i;
            ++line;
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }
}

