/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.beans.property.SimpleObjectProperty;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.resources.ImageKind;

public class DeviceTemplateData {
    private final String name;
    private final String resolution;
    private final String skinName;
    private final String version;
    private final ImageKind icon;
    private final ImageKind selectedIcon;
    private final ImageKind overIcon;
    private final boolean isCustom;
    private final DeviceTemplate template;
    private final SimpleObjectProperty<ROW_STATE> state = new SimpleObjectProperty();

    public DeviceTemplateData(DeviceTemplate template, String version) {
        this.template = template;
        DeviceTemplateValue value = template.getValue();
        this.name = value.getName();
        this.resolution = value.getResolution().getStrTypeValue();
        Skin skin = value.getSkinByManager();
        this.skinName = skin == null ? "" : skin.getName();
        this.version = version;
        this.isCustom = !value.isStandard();
        String profile = value.getProfile();
        if (profile.equals("mobile")) {
            if (this.isCustom) {
                this.icon = ImageKind.PLATFORM_DEVICE_MOBILE_CUSTOM;
                this.overIcon = ImageKind.PLATFORM_DEVICE_MOBILE_CUSTOM_OVER;
                this.selectedIcon = ImageKind.PLATFORM_DEVICE_MOBILE_CUSTOM_SEL;
            } else {
                this.icon = ImageKind.PLATFORM_DEVICE_MOBILE;
                this.overIcon = ImageKind.PLATFORM_DEVICE_MOBILE_OVER;
                this.selectedIcon = ImageKind.PLATFORM_DEVICE_MOBILE_SEL;
            }
        } else if (profile.equals("wearable")) {
            if (this.isCustom) {
                this.icon = ImageKind.PLATFORM_DEVICE_WEARABLE_CUSTOM;
                this.overIcon = ImageKind.PLATFORM_DEVICE_WEARABLE_CUSTOM_OVER;
                this.selectedIcon = ImageKind.PLATFORM_DEVICE_WEARABLE_CUSTOM_SEL;
            } else {
                this.icon = ImageKind.PLATFORM_DEVICE_WEARABLE;
                this.overIcon = ImageKind.PLATFORM_DEVICE_WEARABLE_OVER;
                this.selectedIcon = ImageKind.PLATFORM_DEVICE_WEARABLE_SEL;
            }
        } else if (profile.equals("tv")) {
            if (this.isCustom) {
                this.icon = ImageKind.PLATFORM_DEVICE_TV_CUSTOM;
                this.overIcon = ImageKind.PLATFORM_DEVICE_TV_CUSTOM_OVER;
                this.selectedIcon = ImageKind.PLATFORM_DEVICE_TV_CUSTOM_SEL;
            } else {
                this.icon = ImageKind.PLATFORM_DEVICE_TV;
                this.overIcon = ImageKind.PLATFORM_DEVICE_TV_OVER;
                this.selectedIcon = ImageKind.PLATFORM_DEVICE_TV_SEL;
            }
        } else if (this.isCustom) {
            this.icon = ImageKind.PLATFORM_DEVICE_MOBILE_CUSTOM;
            this.overIcon = ImageKind.PLATFORM_DEVICE_MOBILE_CUSTOM_OVER;
            this.selectedIcon = ImageKind.PLATFORM_DEVICE_MOBILE_CUSTOM_SEL;
        } else {
            this.icon = ImageKind.PLATFORM_DEVICE_MOBILE;
            this.overIcon = ImageKind.PLATFORM_DEVICE_MOBILE_OVER;
            this.selectedIcon = ImageKind.PLATFORM_DEVICE_MOBILE_SEL;
        }
        this.state.set((Object)ROW_STATE.NORMAL);
    }

    public String getName() {
        return this.name;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public DeviceTemplate getTemplate() {
        return this.template;
    }

    public ImageKind getIcon() {
        return this.icon;
    }

    public ImageKind getSelectedIcon() {
        return this.selectedIcon;
    }

    public ImageKind getOverIcon() {
        return this.overIcon;
    }

    public SimpleObjectProperty<ROW_STATE> getState() {
        return this.state;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public String getVersion() {
        return this.version;
    }
}

