/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.util.ArrayList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TableView;
import org.tizen.emulator.manager.ui.controller.create.PlatformItem;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;

class PlatformTableSelectionListener
implements ListChangeListener<Integer> {
    private final TableView<PlatformItem> table;
    private SimpleBooleanProperty okButtonDisabled = new SimpleBooleanProperty(true);
    private SimpleIntegerProperty selectedCount = new SimpleIntegerProperty(0);

    public PlatformTableSelectionListener(TableView<PlatformItem> table) {
        this.table = table;
    }

    public void onChanged(ListChangeListener.Change<? extends Integer> change) {
        for (PlatformItem item : this.table.getItems()) {
            if (item.getRowState().get() != ROW_STATE.SELECTED) continue;
            item.setRowState(ROW_STATE.NORMAL);
            item.setChecked(false);
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (!this.table.getSelectionModel().isSelected(i)) continue;
            selectedItems.add(this.table.getItems().get(i));
        }
        for (PlatformItem platformItem : selectedItems) {
            platformItem.setRowState(ROW_STATE.SELECTED);
            platformItem.setChecked(true);
        }
        this.selectedCount.set(selectedItems.size());
        this.okButtonDisabled.set(this.selectedCount.get() == 0);
    }

    SimpleBooleanProperty getOkButtonDisable() {
        return this.okButtonDisabled;
    }

    int getSelectedCount() {
        return this.selectedCount.get();
    }
}

