/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.ui.dialog.CustomDialog;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.item.BaseViewItem;

public class NetDialog {
    public static String inputHostIPDialog() {
        CustomDialog dialog = new CustomDialog();
        dialog.setTitle("Insert the host IP address");
        final BaseViewItem item = new BaseViewItem();
        final TextField textIP = new TextField();
        item.setViewItem((Node)textIP);
        item.setTitle("Address");
        dialog.getDialogPane().setContent((Node)item.getBasePane());
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        dialog.setResultConverter((Callback)new Callback<ButtonType, String>(){

            public String call(ButtonType param) {
                if (param == ButtonType.CANCEL) {
                    return null;
                }
                if (textIP.getText().isEmpty()) {
                    return null;
                }
                return textIP.getText();
            }
        });
        final Button okButton = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
        okButton.setDisable(true);
        textIP.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String msg;
                String text = newValue;
                if (text.isEmpty()) {
                    item.setState(STATE.ESSENTIAL);
                    item.setStateToolTip("");
                    okButton.setDisable(true);
                }
                if (!(msg = NetworkUtil.checkIPString(true, text, "Host ip")).isEmpty()) {
                    item.setState(STATE.ERROR);
                    item.setStateToolTip(msg);
                    okButton.setDisable(true);
                } else {
                    item.setState(STATE.OK);
                    item.setStateToolTip(msg);
                    okButton.setDisable(false);
                }
            }
        });
        Optional optType = dialog.showAndWait();
        if (optType.isPresent()) {
            return (String)optType.get();
        }
        return null;
    }
}

