/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent.overseer;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import org.tizen.emulator.manager.concurrent.overseer.Job;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class CheckGPU
extends Job {
    private static final String GPU_CHECKER = OSUtil.isWin() ? "check-gl.exe" : "check-gl";
    boolean isGPUSupported = false;
    private boolean isGallium = false;

    CheckGPU() {
    }

    public static boolean isGPUSupported() {
        return CheckGPU.getInstance(CheckGPU.class).isGPUSupported;
    }

    public static boolean isGallium() {
        return CheckGPU.getInstance(CheckGPU.class).isGallium;
    }

    @Override
    public void work() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FilePathResources.getEmulatorCheckToolPath() + File.separator + GPU_CHECKER);
        ProcessResult result = HelperClass.runProcess(cmd, new File(FilePathResources.getEmulatorCheckToolPath()));
        switch (result.getExitValue()) {
            case 0: {
                this.isGPUSupported = true;
                break;
            }
            case 2: {
                this.isGPUSupported = true;
                this.isGallium = true;
                break;
            }
        }
        EMLogger.getLogger().log(Level.INFO, "Support GPU: " + Boolean.toString(this.isGPUSupported));
        EMLogger.getLogger().log(Level.INFO, "Gallium: " + Boolean.toString(this.isGallium));
    }
}

