/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.logging.Level;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMProperty;

public class VMRunningChecker {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunning(VMProperty property) {
        if (property.getHealth() == VMProperty.Health.CORRUPTED) {
            return false;
        }
        if (OSUtil.isWin()) {
            return new File(property.getPropertyValue().getLockFilePath()).exists();
        }
        Path lockfile = Paths.get(property.getPropertyValue().getLockFilePath(), new String[0]);
        if (!Files.exists(lockfile, new LinkOption[0])) {
            return false;
        }
        if (!$assertionsDisabled) {
            if (!Files.isRegularFile(lockfile, new LinkOption[0])) throw new AssertionError();
            if (!Files.isWritable(lockfile)) {
                throw new AssertionError();
            }
        }
        try (FileChannel fc = FileChannel.open(lockfile, StandardOpenOption.READ);){
            FileLock lock = fc.tryLock(0L, 1L, true);
            if (lock != null && lock.isValid()) {
                lock.release();
                Files.delete(lockfile);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            EMLogger.getLogger().fine(e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunningProcess(VMProperty property) throws IOException {
        boolean result = false;
        Process p = null;
        p = VMRunningChecker.makeCheckingProcess();
        if (p == null) {
            return false;
        }
        try (BufferedReader stdOut = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            while ((line = stdOut.readLine()) != null) {
                String re = VMRunningChecker.isRunning(line, property);
                if (re == null) continue;
                EMLogger.getLogger().log(Level.INFO, "emulator instance with the same name is running now (" + re + ")");
                result = true;
                break;
            }
            boolean bl = result;
            return bl;
        }
        catch (IOException err) {
            EMLogger.getLogger().log(Level.SEVERE, "Error occurred while checking if the same VM." + StringResources.NEW_LINE + err.getMessage());
            return false;
        }
    }

    private static String isRunning(String line, VMProperty prop) {
        String vmLaunchConfPath = FilePathResources.getVirtualTargetLaunchConfPath(prop.getPropertyValue().vmName);
        if (line.contains(vmLaunchConfPath)) {
            return vmLaunchConfPath;
        }
        return null;
    }

    private static Process makeCheckingProcess() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (OSUtil.isLinux()) {
            cmd.add("/bin/bash");
            cmd.add("-c");
            cmd.add("/bin/ps -ef | grep emulator-x86");
        } else if (OSUtil.isWin()) {
            cmd.add("cmd.exe");
            cmd.add("/c");
            cmd.add("wmic path win32_process get commandline | findstr emulator-x86");
        } else if (OSUtil.isMac()) {
            cmd.add("/bin/bash");
            cmd.add("-c");
            cmd.add("/bin/ps -ef | grep emulator-x86");
        }
        ProcessBuilder pb = null;
        Process p = null;
        pb = new ProcessBuilder(cmd);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            EMLogger.getLogger().log(Level.SEVERE, "Error occurred while checking if the same VM." + StringResources.NEW_LINE + e.getMessage());
            return null;
        }
        return p;
    }

    public static void checkVMLockFile(VMProperty property) {
        if (!new File(property.getPropertyValue().getLockFilePath()).exists()) {
            return;
        }
        Path lockfile = Paths.get(property.getPropertyValue().getLockFilePath(), new String[0]);
        assert (Files.isRegularFile(lockfile, new LinkOption[0]) && Files.isWritable(lockfile));
        try (FileChannel fc = FileChannel.open(lockfile, StandardOpenOption.READ);){
            FileLock lock = null;
            lock = fc.tryLock(0L, 1L, true);
            if (lock != null && lock.isValid()) {
                lock.release();
                Files.delete(lockfile);
            }
        }
        catch (IOException e) {
            EMLogger.getLogger().fine(e.getMessage());
        }
    }
}

