/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.concurrent.overseer.CheckGPU;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class GPUSupportOption
extends Option {
    private static final String DEVICE_OPTION = "-device";

    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMWorkerException {
        if (property.getPropertyValue().isGLAcceleration) {
            config.addVariable(OPTION_KEY.VAR_WSI, "vigs_wsi");
            config.appendQemuOptions(DEVICE_OPTION, "vigs", "backend=gl,wsi=" + GPUSupportOption.varForm(OPTION_KEY.VAR_WSI) + ",vram_size=268435456");
            config.appendQemuOptions(DEVICE_OPTION, "yagl", "wsi=" + GPUSupportOption.varForm(OPTION_KEY.VAR_WSI));
            if (property.getPropertyValue().getImageVersion().equals("2.4")) {
                config.appendQemuOptions(DEVICE_OPTION, "yagl", "protocol=23");
            }
        } else {
            config.appendQemuOptions(DEVICE_OPTION, "vigs", "backend=sw");
        }
    }

    @Override
    public void checkArgument(VMProperty property) throws VMLauncherException {
        if (CheckGPU.isGallium() && property.getPropertyValue().isGLAcceleration) {
            throw new VMLauncherException(Messages.getString("GPUSupportOption.DriverInfo.0") + StringResources.NEW_LINE + Messages.getString("GPUSupportOption.DriverInfo.1") + StringResources.NEW_LINE + StringResources.NEW_LINE + Messages.getString("GPUSupportOption.DriverInfo.2") + StringResources.NEW_LINE + Messages.getString("GPUSupportOption.DriverInfo.3") + StringResources.NEW_LINE + Messages.getString("GPUSupportOption.DriverInfo.4") + StringResources.NEW_LINE + StringResources.NEW_LINE + Messages.getString("GPUSupportOption.DriverInfo.5") + StringResources.NEW_LINE + Messages.getString("GPUSupportOption.DriverInfo.6"));
        }
    }
}

