/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console.processor;

import java.util.ArrayList;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.CheckVMOption;
import org.tizen.emulator.manager.console.processor.ConsoleException;
import org.tizen.emulator.manager.console.processor.ConsoleProcessor;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.util.OutputUtil;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;

public class ConsoleModifyVM {
    private VMProperty prop;
    private VMPropertyValue oldVM;
    private VMPropertyValue newVM;

    public boolean modifyVM(ArrayList<Option> list) {
        String name = null;
        String deviceName = null;
        for (Option c : list) {
            if (!c.isInCommandLine()) continue;
            switch (c.getShortName().charAt(0)) {
                case 'n': {
                    name = c.getCurrentValue();
                    break;
                }
                case 't': {
                    deviceName = c.getCurrentValue();
                    break;
                }
            }
        }
        if (name == null) {
            return false;
        }
        ConsoleProcessor processor = new ConsoleProcessor();
        this.prop = processor.getProperty(name);
        if (this.prop == null) {
            OutputUtil.printError(name + " " + Messages.getString("Modify.Error.NotExistVM"));
            return false;
        }
        this.oldVM = this.prop.getPropertyValue();
        this.newVM = new VMPropertyValue(this.oldVM);
        if (deviceName != null) {
            DeviceTemplate template = null;
            template = DeviceTemplateUtil.findDeviceTemplateByName(deviceName = deviceName.replace("-", " "), this.newVM.getPlatform());
            if (template == null) {
                OutputUtil.printError(deviceName + " " + Messages.getString("Modify.Error.NotExistDevice"));
                return false;
            }
            String profile = template.getValue().getProfile();
            if (profile == null || !profile.equals(this.newVM.getProfile())) {
                OutputUtil.printError(Messages.getString("Modify.Error.NotMatchProfile"));
                return false;
            }
            this.newVM.setDeviceTemplate(template);
        }
        CheckVMOption checkOption = new CheckVMOption();
        try {
            for (Option c : list) {
                if (c.getLongName() == "name" || !c.isInCommandLine() || c.getLongName() == "name") continue;
                checkOption.setOptions(c, this.newVM);
            }
            if (this.newVM.skin == null) {
                this.newVM.skin = this.newVM.getPlatform().getAvailableSkin(this.newVM.resolution);
            }
            if (this.newVM.skin != null) {
                this.newVM.skinPath = this.newVM.skin.getPath();
            }
        }
        catch (ConsoleException e) {
            OutputUtil.printError(e.getMessage());
            return false;
        }
        try {
            this.prop.getWorker().modifyVM(this.newVM);
        }
        catch (VMWorkerException e) {
            OutputUtil.printError(Messages.getString("Modify.Error.Exception"), e.getMessage());
            return false;
        }
        OutputUtil.print(Messages.getString("Modify.Success"));
        return true;
    }
}

